/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.termgenerator;

import be.ugent.rml.StrictMode;
import be.ugent.rml.functions.FunctionUtils;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import be.ugent.rml.records.Record;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import be.ugent.rml.termgenerator.TermGenerator;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedNodeGenerator
extends TermGenerator {
    private static final Logger logger = LoggerFactory.getLogger(NamedNodeGenerator.class);
    private final String baseIRI;
    private final StrictMode strictMode;

    public NamedNodeGenerator(SingleRecordFunctionExecutor functionExecutor, String baseIRI, StrictMode strictMode) {
        super(functionExecutor);
        this.baseIRI = baseIRI;
        this.strictMode = strictMode;
    }

    @Override
    public List<Term> generate(Record record) throws Exception {
        List<String> objectStrings = FunctionUtils.functionObjectToList(this.functionExecutor.execute(record));
        ArrayList<Term> objects = new ArrayList<Term>();
        if (objectStrings.size() > 0) {
            for (String object : objectStrings) {
                try {
                    ParsedIRI parsedIRI = new ParsedIRI(object);
                    if (!parsedIRI.isAbsolute()) {
                        String iriWithBase = this.baseIRI + object;
                        try {
                            new ParsedIRI(iriWithBase);
                            objects.add(new NamedNode(iriWithBase));
                        }
                        catch (URISyntaxException ue) {
                            if (this.strictMode.equals((Object)StrictMode.STRICT)) {
                                throw new Exception("The base IRI is not valid, so relative IRI '" + object + "' cannot be turned in to absolute IRI.");
                            }
                            logger.error("IRI '{}' Is not valid. Skipped.", (Object)iriWithBase);
                        }
                        continue;
                    }
                    objects.add(new NamedNode(object));
                }
                catch (URISyntaxException e) {
                    if (this.strictMode.equals((Object)StrictMode.STRICT)) {
                        throw new Exception("IRI " + object + " is not valid");
                    }
                    logger.error("IRI '{}' is not valid. Skipped.", (Object)object);
                }
            }
        }
        return objects;
    }
}

