/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.store.Quad;
import be.ugent.rml.target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileTarget
implements Target {
    private String path;
    private String basePath;
    private String serializationFormat;
    private String compression;
    private List<Quad> metadata;
    private OutputStream outputStream;
    private static final Logger logger = LoggerFactory.getLogger(LocalFileTarget.class);

    public LocalFileTarget(String path, String basePath, String serializationFormat, String compression, List<Quad> metadata) {
        this.path = path;
        this.basePath = basePath;
        this.serializationFormat = serializationFormat;
        this.compression = compression;
        this.metadata = metadata;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        File file = new File(this.path);
        if (!file.isAbsolute()) {
            file = FileUtils.getFile((String[])new String[]{this.basePath, this.path});
        }
        this.outputStream = new FileOutputStream(file);
        if (this.compression != null) {
            switch (this.compression.toLowerCase()) {
                case "gzip": {
                    this.outputStream = new GZIPOutputStream(this.outputStream);
                    break;
                }
                default: {
                    throw new IOException("Compression " + this.compression + " not implemented!");
                }
            }
        }
        return this.outputStream;
    }

    @Override
    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    public boolean equals(Object o) {
        if (o instanceof LocalFileTarget) {
            LocalFileTarget target = (LocalFileTarget)o;
            return this.path.equals(target.getPath()) && this.basePath.equals(target.getBasePath());
        }
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public void close() {
        logger.debug("Closing target");
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            logger.error("Failed to close target. ", (Throwable)e);
        }
    }

    @Override
    public List<Quad> getMetadata() {
        return this.metadata;
    }
}

