/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import be.ugent.rml.records.Record;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IteratorFormat<DocumentClass>
implements ReferenceFormulationRecordFactory {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private HashMap<Access, DocumentClass> documentMap = new HashMap();

    @Override
    public List<Record> getRecords(Access access, Term logicalSource, QuadStore rmlStore) throws IOException, SQLException, ClassNotFoundException {
        List<Term> iterators;
        if (!this.documentMap.containsKey(access)) {
            this.logger.debug("No document found for {}. Creating new one", (Object)access);
            try (InputStream stream = access.getInputStream();){
                this.documentMap.put(access, this.getDocumentFromStream(stream, access.getContentType()));
            }
        }
        if (!(iterators = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#iterator"), null))).isEmpty()) {
            String iterator = iterators.get(0).getValue();
            return this.getRecordsFromDocument(this.documentMap.get(access), iterator);
        }
        String iterator = "/Results/row";
        return this.getRecordsFromDocument(this.documentMap.get(access), iterator);
    }

    abstract List<Record> getRecordsFromDocument(DocumentClass var1, String var2) throws IOException;

    abstract DocumentClass getDocumentFromStream(InputStream var1) throws IOException;

    DocumentClass getDocumentFromStream(InputStream stream, String contentType) throws IOException {
        return this.getDocumentFromStream(stream);
    }
}

