/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.functions;

import be.ugent.rml.Utils;
import be.ugent.rml.extractor.ConstantExtractor;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.functions.FunctionUtils;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import be.ugent.rml.records.Record;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatFunction
implements SingleRecordFunctionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ConcatFunction.class);
    private boolean encodeURI;
    private List<Extractor> extractors;

    public ConcatFunction(List<Extractor> extractors, boolean encodeURI) {
        this.extractors = extractors;
        this.encodeURI = encodeURI;
    }

    @Override
    public List<?> execute(Record record) {
        return this.concat(record);
    }

    private List<String> concat(Record record) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("");
        boolean allValuesFound = true;
        int referenceCount = 0;
        Object onlyConstants = "";
        for (int i = 0; allValuesFound && i < this.extractors.size(); ++i) {
            Extractor extractor = this.extractors.get(i);
            List<String> extractedValues = FunctionUtils.functionObjectToList(extractor.extract(record));
            if (!extractedValues.isEmpty()) {
                ArrayList<Object> temp = new ArrayList<Object>();
                for (int k = 0; k < results.size(); ++k) {
                    for (int j = 0; j < extractedValues.size(); ++j) {
                        Object result = results.get(k);
                        String value = extractedValues.get(j);
                        if (this.encodeURI && extractor instanceof ReferenceExtractor) {
                            value = Utils.encodeURI(value);
                        }
                        result = (String)result + value;
                        if (extractor instanceof ConstantExtractor) {
                            onlyConstants = (String)onlyConstants + value;
                        }
                        temp.add(result);
                    }
                    if (!(extractor instanceof ReferenceExtractor)) continue;
                    ++referenceCount;
                }
                results = temp;
            }
            if (!extractedValues.isEmpty()) continue;
            logger.warn("Not all values for a template where found. More specific, the variable {} did not provide any results.", (Object)extractor);
            allValuesFound = false;
        }
        if (allValuesFound && referenceCount > 0 && results.contains(onlyConstants) || !allValuesFound) {
            results = new ArrayList();
        }
        return results;
    }
}

