/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.cli;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.AgentFactory;
import be.ugent.knows.idlabFunctions.IDLabFunctions;
import be.ugent.rml.Executor;
import be.ugent.rml.StrictMode;
import be.ugent.rml.Utils;
import be.ugent.rml.conformer.MappingConformer;
import be.ugent.rml.metadata.MetadataGenerator;
import be.ugent.rml.records.RecordsFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.store.RDF4JStore;
import be.ugent.rml.store.SimpleQuadStore;
import be.ugent.rml.target.Target;
import be.ugent.rml.target.TargetFactory;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import ch.qos.logback.classic.Level;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final Marker fatal = MarkerFactory.getMarker((String)"FATAL");

    public static void main(String[] args) {
        try {
            Main.run(args, System.getProperty("user.dir"));
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public static void run(String[] args) throws Exception {
        Main.run(args, System.getProperty("user.dir"));
    }

    public static void run(String[] args, String basePath) throws Exception {
        Options options = new Options();
        Option mappingdocOption = Option.builder((String)"m").longOpt("mappingfile").hasArg().numberOfArgs(-2).desc("one or more mapping file paths and/or strings (multiple values are concatenated). r2rml is converted to rml if needed using the r2rml arguments.RDF Format is determined based on extension.").build();
        Option privateSecurityDataOption = Option.builder((String)"psd").longOpt("privatesecuritydata").hasArg().numberOfArgs(-2).desc("one or more private security files containing all private security information such as usernames, passwords, certificates, etc.").build();
        Option outputfileOption = Option.builder((String)"o").longOpt("outputfile").hasArg().desc("path to output file (default: stdout)").build();
        Option functionfileOption = Option.builder((String)"f").longOpt("functionfile").hasArg().numberOfArgs(-2).desc("one or more function file paths (dynamic functions with relative paths are found relative to the cwd)").build();
        Option triplesmapsOption = Option.builder((String)"t").longOpt("triplesmaps").hasArg().desc("IRIs of the triplesmaps that should be executed in order, split by ',' (default is all triplesmaps)").build();
        Option removeduplicatesOption = Option.builder((String)"d").longOpt("duplicates").desc("remove duplicates in the HDT, N-Triples, or N-Quads output").build();
        Option configfileOption = Option.builder((String)"c").longOpt("configfile").hasArg().desc("path to configuration file").build();
        Option helpOption = Option.builder((String)"h").longOpt("help").desc("show help info").build();
        Option verboseOption = Option.builder((String)"v").longOpt("verbose").desc("show more details in debugging output").build();
        Option metadataOption = Option.builder((String)"e").longOpt("metadatafile").hasArg().desc("path to output metadata file").build();
        Option metadataDetailLevelOption = Option.builder((String)"l").longOpt("metadataDetailLevel").hasArg().desc("generate metadata on given detail level (dataset - triple - term)").build();
        Option serializationFormatOption = Option.builder((String)"s").longOpt("serialization").desc("serialization format (nquads (default), turtle, trig, trix, jsonld, hdt)").hasArg().build();
        Option jdbcDSNOption = Option.builder((String)"dsn").longOpt("r2rml-jdbcDSN").desc("DSN of the database when using R2RML rules").hasArg().build();
        Option passwordOption = Option.builder((String)"p").longOpt("r2rml-password").desc("password of the database when using R2RML rules").hasArg().build();
        Option usernameOption = Option.builder((String)"u").longOpt("r2rml-username").desc("username of the database when using R2RML rules").hasArg().build();
        Option strictModeOption = Option.builder().longOpt("strict").desc("Enable strict mode. In strict mode, the mapper will fail on invalid IRIs instead of skipping them.").build();
        Option baseIriOption = Option.builder((String)"b").longOpt("base-iri").desc("Base IRI used to expand relative IRIs in generated terms in the output.").hasArg().build();
        options.addOption(mappingdocOption);
        options.addOption(privateSecurityDataOption);
        options.addOption(outputfileOption);
        options.addOption(functionfileOption);
        options.addOption(removeduplicatesOption);
        options.addOption(triplesmapsOption);
        options.addOption(configfileOption);
        options.addOption(helpOption);
        options.addOption(verboseOption);
        options.addOption(serializationFormatOption);
        options.addOption(metadataOption);
        options.addOption(metadataDetailLevelOption);
        options.addOption(jdbcDSNOption);
        options.addOption(passwordOption);
        options.addOption(usernameOption);
        options.addOption(strictModeOption);
        options.addOption(baseIriOption);
        DefaultParser parser = new DefaultParser();
        try {
            Agent functionAgent;
            boolean strict;
            CommandLine lineArgs = parser.parse(options, args);
            Properties configFile = null;
            if (lineArgs.hasOption("c")) {
                configFile = new Properties();
                try (Reader reader = Utils.getReaderFromLocation(lineArgs.getOptionValue("c"));){
                    configFile.load(reader);
                }
            }
            if (Main.checkOptionPresence(helpOption, lineArgs, configFile)) {
                Main.printHelp(options);
                return;
            }
            if (Main.checkOptionPresence(verboseOption, lineArgs, configFile)) {
                Main.setLoggerLevel(Level.DEBUG);
            } else {
                Main.setLoggerLevel(Level.ERROR);
            }
            String[] mOptionValue = Main.getOptionValues(mappingdocOption, lineArgs, configFile);
            List<Object> lis = new ArrayList();
            if (mOptionValue == null && System.console() != null) {
                Main.printHelp(options);
                throw new IllegalArgumentException("No mapping file nor via stdin found!");
            }
            String outputFile = Main.getPriorityOptionValue(outputfileOption, lineArgs, configFile);
            if (outputFile != null && !Utils.checkPathParent(outputFile = outputFile.replaceAll("\\\\", "/"), null)) {
                logger.error(fatal, "The given output path does not exist.");
                throw new IllegalArgumentException("The given output path does not exist.");
            }
            if (mOptionValue != null) {
                lis = Arrays.stream(mOptionValue).map(Utils::getInputStreamFromFileOrContentString).collect(Collectors.toList());
            }
            try {
                BufferedInputStream bis = new BufferedInputStream(System.in);
                int available = bis.available();
                if (available > 0) {
                    byte[] byArray = new byte[32];
                    bis.mark(32);
                    int bytesRead = bis.read(byArray);
                    bis.reset();
                    if (bytesRead > 0) {
                        int addStream = 0;
                        for (byte aByte : byArray) {
                            if (aByte == 0 || aByte == 4) continue;
                            addStream = 1;
                            break;
                        }
                        if (addStream != 0) {
                            lis.add(bis);
                        }
                    }
                }
            }
            catch (IOException ex) {
                logger.warn("Error trying to check System.in: {}", (Object)ex.getMessage());
            }
            SequenceInputStream is = new SequenceInputStream(Collections.enumeration(lis));
            HashMap<String, String> mappingOptions = new HashMap<String, String>();
            for (Option option : new Option[]{jdbcDSNOption, passwordOption, usernameOption}) {
                if (!Main.checkOptionPresence(option, lineArgs, configFile)) continue;
                mappingOptions.put(option.getLongOpt().replace("r2rml-", ""), Main.getOptionValues(option, lineArgs, configFile)[0]);
            }
            RDF4JStore rDF4JStore = new RDF4JStore();
            try {
                rDF4JStore.read(is, null, RDFFormat.TURTLE);
            }
            catch (RDFParseException e) {
                logger.error(fatal, "Unable to parse mapping rules as Turtle. Does the file exist and is it valid Turtle?", (Throwable)e);
                throw new IllegalArgumentException("Unable to parse mapping rules as Turtle. Does the file exist and is it valid Turtle?");
            }
            if (lineArgs.hasOption("psd")) {
                String[] mOptionValuePrivateSecurityData = Main.getOptionValues(privateSecurityDataOption, lineArgs, configFile);
                List lisPrivateSecurityData = Arrays.stream(mOptionValuePrivateSecurityData).map(Utils::getInputStreamFromFileOrContentString).collect(Collectors.toList());
                try (SequenceInputStream isPrivateSecurityData = new SequenceInputStream(Collections.enumeration(lisPrivateSecurityData));){
                    rDF4JStore.read(isPrivateSecurityData, null, RDFFormat.TURTLE);
                }
                catch (RDFParseException e) {
                    logger.debug(e.getMessage());
                    logger.error(fatal, "Unable to parse private security data as Turtle. Does the file exist and is it valid Turtle?");
                    throw new IllegalArgumentException("Unable to parse private security data as Turtle. Does the file exist and is it valid Turtle?");
                }
            }
            MappingConformer conformer = new MappingConformer(rDF4JStore, mappingOptions);
            try {
                boolean conversionNeeded = conformer.conform();
                if (conversionNeeded) {
                    logger.info("Conversion to RML was needed.");
                }
            }
            catch (Exception e) {
                logger.error(fatal, "Failed to make mapping file conformant to RML spec.", (Throwable)e);
            }
            RecordsFactory factory = new RecordsFactory(basePath);
            String outputFormat = Main.getPriorityOptionValue(serializationFormatOption, lineArgs, configFile);
            QuadStore outputStore = Main.getStoreForFormat(outputFormat);
            MetadataGenerator metadataGenerator = null;
            String metadataFile = Main.getPriorityOptionValue(metadataOption, lineArgs, configFile);
            String requestedDetailLevel = Main.getPriorityOptionValue(metadataDetailLevelOption, lineArgs, configFile);
            if (Main.checkOptionPresence(metadataOption, lineArgs, configFile)) {
                if (requestedDetailLevel != null) {
                    MetadataGenerator.DETAIL_LEVEL detailLevel;
                    switch (requestedDetailLevel) {
                        case "dataset": {
                            detailLevel = MetadataGenerator.DETAIL_LEVEL.DATASET;
                            break;
                        }
                        case "triple": {
                            detailLevel = MetadataGenerator.DETAIL_LEVEL.TRIPLE;
                            break;
                        }
                        case "term": {
                            detailLevel = MetadataGenerator.DETAIL_LEVEL.TERM;
                            break;
                        }
                        default: {
                            logger.error("Unknown metadata detail level option. Use the -h flag for more info.");
                            return;
                        }
                    }
                    QuadStore metadataStore = Main.getStoreForFormat(outputFormat);
                    metadataGenerator = new MetadataGenerator(detailLevel, Main.getPriorityOptionValue(metadataOption, lineArgs, configFile), mOptionValue, rDF4JStore, metadataStore);
                } else {
                    logger.error("Please specify the detail level when requesting metadata generation. Use the -h flag for more info.");
                }
            }
            StrictMode strictMode = (strict = Main.checkOptionPresence(strictModeOption, lineArgs, configFile)) ? StrictMode.STRICT : StrictMode.BEST_EFFORT;
            String baseIRI = Main.getPriorityOptionValue(baseIriOption, lineArgs, configFile);
            if (baseIRI == null || baseIRI.isEmpty()) {
                if (strictMode.equals((Object)StrictMode.STRICT)) {
                    throw new Exception("When running in strict mode, a base IRI argument must be set.");
                }
                if (mOptionValue != null) {
                    lis = Arrays.stream(mOptionValue).map(Utils::getInputStreamFromFileOrContentString).collect(Collectors.toList());
                }
                try (SequenceInputStream is2 = new SequenceInputStream(Collections.enumeration(lis));){
                    baseIRI = Utils.getBaseDirectiveTurtle(is2);
                }
            }
            Object[] fOptionValue = Main.getOptionValues(functionfileOption, lineArgs, configFile);
            ArrayList<Term> triplesMaps = new ArrayList<Term>();
            String tOptionValue = Main.getPriorityOptionValue(triplesmapsOption, lineArgs, configFile);
            if (tOptionValue != null) {
                List<String> triplesMapsIRI = Arrays.asList(tOptionValue.split(","));
                triplesMapsIRI.forEach(iri -> triplesMaps.add(new NamedNode((String)iri)));
            }
            if (fOptionValue == null) {
                functionAgent = AgentFactory.createFromFnO((String[])new String[]{"fno/functions_idlab.ttl", "fno/functions_idlab_classes_java_mapping.ttl", "functions_grel.ttl", "grel_java_mapping.ttl"});
            } else {
                logger.debug("Using custom path to functions.ttl file: {}", (Object)Arrays.toString(fOptionValue));
                String[] optionWithIDLabFunctionArgs = new String[fOptionValue.length + 2];
                optionWithIDLabFunctionArgs[0] = "fno/functions_idlab.ttl";
                optionWithIDLabFunctionArgs[1] = "fno/functions_idlab_classes_java_mapping.ttl";
                System.arraycopy(fOptionValue, 0, optionWithIDLabFunctionArgs, 2, fOptionValue.length);
                functionAgent = AgentFactory.createFromFnO((String[])optionWithIDLabFunctionArgs);
            }
            Executor executor = new Executor(rDF4JStore, factory, outputStore, baseIRI, strictMode, functionAgent);
            executor.verifySources(basePath);
            if (metadataGenerator != null) {
                metadataGenerator.preMappingGeneration(triplesMaps.isEmpty() ? executor.getTriplesMaps() : triplesMaps, rDF4JStore);
            }
            String startTimestamp = Instant.now().toString();
            QuadStore result = null;
            try {
                HashMap<Term, QuadStore> hashMap = executor.execute(triplesMaps, Main.checkOptionPresence(removeduplicatesOption, lineArgs, configFile), metadataGenerator);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw e;
            }
            finally {
                functionAgent.close();
            }
            HashMap<Term, QuadStore> targets = executor.getTargets();
            if (targets != null) {
                result = targets.get(new NamedNode("rmlmapper://default.store"));
                if (result != null) {
                    result.copyNameSpaces(rDF4JStore);
                }
                result.copyNameSpaces(rDF4JStore);
                IDLabFunctions.saveState();
                Main.writeOutputTargets(targets, rDF4JStore, basePath, outputFile, outputFormat);
            }
            String stopTimestamp = Instant.now().toString();
            if (metadataGenerator != null && targets != null) {
                metadataGenerator.postMappingGeneration(startTimestamp, stopTimestamp, result);
                Main.writeOutput(metadataGenerator.getResult(), metadataFile, outputFormat);
            }
        }
        catch (ParseException exp) {
            logger.error("Parsing failed. Reason: {}", (Object)exp.getMessage());
            Main.printHelp(options);
        }
        catch (IllegalArgumentException exp) {
            throw exp;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void writeOutputTargets(HashMap<Term, QuadStore> targets, QuadStore rmlStore, String basePath, String outputFileDefault, String outputFormatDefault) throws Exception {
        boolean hasNoResults = true;
        logger.debug("Writing to Targets: {}", targets.keySet());
        TargetFactory targetFactory = new TargetFactory(basePath);
        for (Map.Entry<Term, QuadStore> termTargetMapping : targets.entrySet()) {
            Term term = termTargetMapping.getKey();
            QuadStore store = termTargetMapping.getValue();
            if (store.size() > 0) {
                hasNoResults = false;
                logger.info("Target: {} has {} results", (Object)term, (Object)store.size());
            }
            if (term.getValue().equals("rmlmapper://default.store")) {
                logger.debug("Exporting to default Target");
                Main.writeOutput(store, outputFileDefault, outputFormatDefault);
                continue;
            }
            logger.debug("Exporting to Target: {}", (Object)term);
            if (store.size() > 1) {
                logger.info("{} quads were generated for {} Target", (Object)store.size(), (Object)term);
            } else {
                logger.info("{} quad was generated {} Target", (Object)store.size(), (Object)term);
            }
            Target target = targetFactory.getTarget(term, rmlStore, store);
            String serializationFormat = target.getSerializationFormat();
            OutputStream output = target.getOutputStream();
            store.addQuads(target.getMetadata());
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(output, Charset.defaultCharset()));){
                store.write(out, serializationFormat);
            }
            target.close();
        }
        if (hasNoResults) {
            logger.info("No results!");
        }
    }

    private static boolean checkOptionPresence(Option option, CommandLine lineArgs, Properties properties) {
        return option.getOpt() != null && lineArgs.hasOption(option.getOpt()) || option.getLongOpt() != null && lineArgs.hasOption(option.getLongOpt()) || properties != null && properties.getProperty(option.getLongOpt()) != null && !properties.getProperty(option.getLongOpt()).equals("false");
    }

    private static String getPriorityOptionValue(Option option, CommandLine lineArgs, Properties properties) {
        if (lineArgs.hasOption(option.getOpt())) {
            return lineArgs.getOptionValue(option.getOpt());
        }
        if (properties != null && properties.getProperty(option.getLongOpt()) != null) {
            return properties.getProperty(option.getLongOpt());
        }
        return null;
    }

    private static String[] getOptionValues(Option option, CommandLine lineArgs, Properties properties) {
        if (lineArgs.hasOption(option.getOpt())) {
            return lineArgs.getOptionValues(option.getOpt());
        }
        if (properties != null && properties.getProperty(option.getLongOpt()) != null) {
            return properties.getProperty(option.getLongOpt()).split(" ");
        }
        return null;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar mapper.jar <options>\noptions:", options);
    }

    private static void setLoggerLevel(Level level) {
        Logger root = LoggerFactory.getLogger((String)"ROOT");
        ((ch.qos.logback.classic.Logger)root).setLevel(level);
    }

    private static void writeOutput(QuadStore store, String outputFile, String format) {
        boolean hdt;
        boolean bl = hdt = format != null && format.equals("hdt");
        if (hdt) {
            try {
                format = "nquads";
                File tmpFile = File.createTempFile("file", ".nt");
                tmpFile.deleteOnExit();
                String uncompressedOutputFile = tmpFile.getAbsolutePath();
                File nquadsFile = Main.writeOutputUncompressed(store, uncompressedOutputFile, format);
                Utils.ntriples2hdt(uncompressedOutputFile, outputFile);
                nquadsFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            format = format != null ? format.toLowerCase() : "nquads";
            Main.writeOutputUncompressed(store, outputFile, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeOutputUncompressed(QuadStore store, String outputFile, String format) {
        File targetFile = null;
        if (store.size() > 1) {
            logger.info("{} quads were generated for default Target", (Object)store.size());
        } else {
            logger.info("{} quad was generated for default Target", (Object)store.size());
        }
        Writer out = null;
        try {
            String doneMessage = null;
            if (outputFile != null) {
                targetFile = new File(outputFile);
                logger.info("Writing quads to {}...", (Object)targetFile.getPath());
                if (!targetFile.isAbsolute()) {
                    targetFile = new File(System.getProperty("user.dir") + "/" + outputFile);
                }
                doneMessage = "Writing to " + targetFile.getPath() + " is done.";
                out = Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            } else {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
            }
            store.write(out, format);
            out.close();
            if (doneMessage != null) {
                logger.info(doneMessage);
            }
        }
        catch (Exception e) {
            logger.error("Writing output failed. Reason: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("Could not close writer. ", (Throwable)e);
                }
            }
        }
        return targetFile;
    }

    private static QuadStore getStoreForFormat(String outputFormat) {
        if (outputFormat == null || outputFormat.equals("nquads") || outputFormat.equals("hdt")) {
            return new SimpleQuadStore();
        }
        return new RDF4JStore();
    }
}

