/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.rml.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MyFileUtils {
    private static Logger logger = LoggerFactory.getLogger(MyFileUtils.class);

    MyFileUtils() {
    }

    static File getResourceAsFile(String resource) throws IOException {
        logger.debug("Searching for '{}' in resources.", (Object)resource);
        ClassLoader cl = Utils.class.getClassLoader();
        URL resourceUrl = cl.getResource(resource);
        logger.debug("default class loader found '{}'", (Object)resourceUrl);
        if (resourceUrl == null) {
            throw new IOException("Resource file " + resource + " doesn't exist");
        }
        if ("file".equals(resourceUrl.getProtocol())) {
            try {
                String path = resourceUrl.toURI().getRawPath();
                logger.debug("returning file '{}'", (Object)path);
                return new File(path);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to get file through class loader: " + cl, e);
            }
        }
        throw new IOException("Unable to get file through class loader: " + cl);
    }

    public static String getParentPath(Class c, String path) {
        ClassLoader classLoader = c.getClassLoader();
        URL url = classLoader.getResource(path);
        if (url != null) {
            path = url.getFile();
        }
        File outputFile = new File(path);
        return outputFile.getParent();
    }
}

