/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.AgentFactory;
import be.ugent.rml.Mapping;
import be.ugent.rml.MappingFactory;
import be.ugent.rml.StrictMode;
import be.ugent.rml.Utils;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Initializer {
    private final MappingFactory factory;
    private final QuadStore rmlStore;
    private final List<Term> triplesMaps;
    private final HashMap<Term, Mapping> mappings;

    public Initializer(QuadStore rmlStore, Agent functionAgent, String baseIRI, StrictMode strictMode) throws Exception {
        this.rmlStore = rmlStore;
        this.triplesMaps = this.getAllTriplesMaps();
        this.mappings = new HashMap();
        Agent initialisedFunctionAgent = functionAgent == null ? AgentFactory.createFromFnO((String[])new String[]{"fno/functions_idlab.ttl", "fno/functions_idlab_classes_java_mapping.ttl", "functions_grel.ttl", "grel_java_mapping.ttl"}) : functionAgent;
        this.factory = new MappingFactory(initialisedFunctionAgent, baseIRI, strictMode);
        this.extractMappings();
    }

    private void extractMappings() throws Exception {
        for (Term triplesMap : this.triplesMaps) {
            this.mappings.put(triplesMap, this.factory.createMapping(triplesMap, this.rmlStore));
        }
    }

    private List<Term> getAllTriplesMaps() {
        List<Term> maps = Utils.getSubjectsFromQuads(this.rmlStore.getQuads(null, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
        ArrayList<Term> temp = new ArrayList<Term>();
        for (Term map : maps) {
            if (!this.rmlStore.getQuads(null, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), map).isEmpty()) continue;
            temp.add(map);
        }
        maps = temp;
        if (maps.isEmpty()) {
            throw new Error("No Triples Maps found. The mapping document you should at least have one Triples Map.");
        }
        return maps;
    }

    public HashMap<Term, Mapping> getMappings() {
        return this.mappings;
    }

    public List<Term> getTriplesMaps() {
        return this.triplesMaps;
    }
}

