/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.rml.Initializer;
import be.ugent.rml.Mapping;
import be.ugent.rml.MappingInfo;
import be.ugent.rml.PredicateObjectGraph;
import be.ugent.rml.PredicateObjectGraphMapping;
import be.ugent.rml.StrictMode;
import be.ugent.rml.Utils;
import be.ugent.rml.access.LocalFileAccess;
import be.ugent.rml.access.RemoteFileAccess;
import be.ugent.rml.functions.MultipleRecordsFunctionExecutor;
import be.ugent.rml.metadata.Metadata;
import be.ugent.rml.metadata.MetadataGenerator;
import be.ugent.rml.records.Record;
import be.ugent.rml.records.RecordsFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.store.RDF4JStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.ProvenancedQuad;
import be.ugent.rml.term.ProvenancedTerm;
import be.ugent.rml.term.Term;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    private Initializer initializer;
    private HashMap<Term, List<Record>> recordsHolders;
    private HashMap<Term, HashMap<Integer, ProvenancedTerm>> subjectCache;
    private QuadStore resultingQuads;
    private QuadStore rmlStore;
    private HashMap<Term, QuadStore> targetStores;
    private RecordsFactory recordsFactory;
    private static int blankNodeCounter;
    private HashMap<Term, Mapping> mappings;

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, String baseIRI, StrictMode strictMode, Agent functionAgent) throws Exception {
        this(rmlStore, recordsFactory, null, baseIRI, strictMode, functionAgent);
    }

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, QuadStore resultingQuads, String baseIRI, Agent functionAgent) throws Exception {
        this(rmlStore, recordsFactory, resultingQuads, baseIRI, StrictMode.BEST_EFFORT, functionAgent);
    }

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, QuadStore resultingQuads, String baseIRI, StrictMode strictMode, Agent functionAgent) throws Exception {
        this.initializer = new Initializer(rmlStore, functionAgent, baseIRI, strictMode);
        this.mappings = this.initializer.getMappings();
        this.rmlStore = rmlStore;
        this.recordsFactory = recordsFactory;
        this.recordsHolders = new HashMap();
        this.subjectCache = new HashMap();
        this.targetStores = new HashMap();
        blankNodeCounter = 0;
        this.resultingQuads = resultingQuads == null ? new RDF4JStore() : resultingQuads;
        for (Map.Entry<Term, Mapping> tm : this.mappings.entrySet()) {
            Mapping mapping = tm.getValue();
            HashSet<Term> targets = new HashSet<Term>();
            MappingInfo subjectMapInfo = mapping.getSubjectMappingInfo();
            targets.addAll(subjectMapInfo.getTargets());
            for (PredicateObjectGraphMapping pog : mapping.getPredicateObjectGraphMappings()) {
                if (pog.getPredicateMappingInfo() != null) {
                    targets.addAll(pog.getPredicateMappingInfo().getTargets());
                }
                if (pog.getObjectMappingInfo() == null) continue;
                targets.addAll(pog.getObjectMappingInfo().getTargets());
            }
            for (MappingInfo g : mapping.getGraphMappingInfos()) {
                targets.addAll(g.getTargets());
            }
            for (Term t : targets) {
                logger.debug("Adding target for {}", (Object)t);
                this.targetStores.put(t, new RDF4JStore());
            }
        }
    }

    public Executor(RDF4JStore rmlStore, RecordsFactory factory, QuadStore outputStore, Agent functionAgent) throws Exception {
        this((QuadStore)rmlStore, factory, outputStore, rmlStore.getBase(), functionAgent);
    }

    public HashMap<Term, QuadStore> execute(List<Term> triplesMaps, boolean removeDuplicates, MetadataGenerator metadataGenerator) throws Exception {
        BiConsumer<ProvenancedTerm, PredicateObjectGraph> pogFunction = metadataGenerator != null && metadataGenerator.getDetailLevel().getLevel() >= MetadataGenerator.DETAIL_LEVEL.TRIPLE.getLevel() ? (subject, pog) -> {
            this.generateQuad((ProvenancedTerm)subject, pog.getPredicate(), pog.getObject(), pog.getGraph());
            metadataGenerator.insertQuad(new ProvenancedQuad((ProvenancedTerm)subject, pog.getPredicate(), pog.getObject(), pog.getGraph()));
        } : (subject, pog) -> this.generateQuad((ProvenancedTerm)subject, pog.getPredicate(), pog.getObject(), pog.getGraph());
        return this.executeWithFunction(triplesMaps, removeDuplicates, pogFunction);
    }

    public HashMap<Term, QuadStore> executeWithFunction(List<Term> triplesMaps, boolean removeDuplicates, BiConsumer<ProvenancedTerm, PredicateObjectGraph> pogFunction) throws Exception {
        if (triplesMaps == null || triplesMaps.isEmpty()) {
            triplesMaps = this.initializer.getTriplesMaps();
        }
        for (Term triplesMap : triplesMaps) {
            Mapping mapping = this.mappings.get(triplesMap);
            List<Record> records = this.getRecords(triplesMap);
            for (int j = 0; j < records.size(); ++j) {
                ProvenancedTerm subject;
                Record record = records.get(j);
                ProvenancedTerm finalSubject = subject = this.getSubject(triplesMap, mapping, record, j);
                if (subject == null) continue;
                ArrayList<ProvenancedTerm> subjectGraphs = new ArrayList<ProvenancedTerm>();
                mapping.getGraphMappingInfos().forEach(mappingInfo -> {
                    List<Term> terms = null;
                    try {
                        terms = mappingInfo.getTermGenerator().generate(record);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    terms.forEach(term -> {
                        if (!term.equals(new NamedNode("http://www.w3.org/ns/r2rml#defaultGraph"))) {
                            subjectGraphs.add(new ProvenancedTerm((Term)term));
                        }
                    });
                });
                List<PredicateObjectGraph> pogs = this.generatePredicateObjectGraphs(mapping, record, subjectGraphs);
                pogs.forEach(pog -> pogFunction.accept(finalSubject, (PredicateObjectGraph)pog));
            }
        }
        if (removeDuplicates) {
            this.resultingQuads.removeDuplicates();
        }
        this.targetStores.put(new NamedNode("rmlmapper://default.store"), this.resultingQuads);
        return this.targetStores;
    }

    public HashMap<Term, QuadStore> execute(List<Term> triplesMaps) throws Exception {
        return this.execute(triplesMaps, false, null);
    }

    private List<PredicateObjectGraph> generatePredicateObjectGraphs(Mapping mapping, Record record, List<ProvenancedTerm> alreadyNeededGraphs) throws Exception {
        ArrayList<PredicateObjectGraph> results = new ArrayList<PredicateObjectGraph>();
        List<PredicateObjectGraphMapping> predicateObjectGraphMappings = mapping.getPredicateObjectGraphMappings();
        for (PredicateObjectGraphMapping pogMapping : predicateObjectGraphMappings) {
            List<Object> objects;
            ArrayList<ProvenancedTerm> predicates = new ArrayList<ProvenancedTerm>();
            ArrayList<ProvenancedTerm> poGraphs = new ArrayList<ProvenancedTerm>();
            poGraphs.addAll(alreadyNeededGraphs);
            if (pogMapping.getGraphMappingInfo() != null && pogMapping.getGraphMappingInfo().getTermGenerator() != null) {
                pogMapping.getGraphMappingInfo().getTermGenerator().generate(record).forEach(term -> {
                    if (!term.equals(new NamedNode("http://www.w3.org/ns/r2rml#defaultGraph"))) {
                        poGraphs.add(new ProvenancedTerm((Term)term));
                    }
                });
            }
            pogMapping.getPredicateMappingInfo().getTermGenerator().generate(record).forEach(p -> predicates.add(new ProvenancedTerm((Term)p, pogMapping.getPredicateMappingInfo())));
            if (pogMapping.getObjectMappingInfo() != null && pogMapping.getObjectMappingInfo().getTermGenerator() != null) {
                objects = pogMapping.getObjectMappingInfo().getTermGenerator().generate(record);
                ArrayList<ProvenancedTerm> provenancedObjects = new ArrayList<ProvenancedTerm>();
                objects.forEach(object -> provenancedObjects.add(new ProvenancedTerm((Term)object, pogMapping.getObjectMappingInfo())));
                if (objects.size() <= 0) continue;
                results.addAll(this.combineMultiplePOGs(predicates, provenancedObjects, poGraphs));
                continue;
            }
            if (pogMapping.getParentTriplesMap() == null) continue;
            objects = !pogMapping.getJoinConditions().isEmpty() ? this.getIRIsWithConditions(record, pogMapping.getParentTriplesMap(), pogMapping.getJoinConditions()) : this.getAllIRIs(pogMapping.getParentTriplesMap());
            results.addAll(this.combineMultiplePOGs(predicates, objects, poGraphs));
        }
        return results;
    }

    private void generateQuad(ProvenancedTerm subject, ProvenancedTerm predicate, ProvenancedTerm object, ProvenancedTerm graph) {
        Term g = null;
        HashSet<Term> targets = new HashSet<Term>();
        if (graph != null) {
            g = graph.getTerm();
            targets.addAll(graph.getTargets());
        }
        if (subject != null && predicate != null && object != null) {
            targets.addAll(subject.getTargets());
            targets.addAll(predicate.getTargets());
            targets.addAll(object.getTargets());
            if (!targets.isEmpty()) {
                for (Term t : targets) {
                    this.targetStores.get(t).addQuad(subject.getTerm(), predicate.getTerm(), object.getTerm(), g);
                }
            } else {
                this.resultingQuads.addQuad(subject.getTerm(), predicate.getTerm(), object.getTerm(), g);
            }
        }
    }

    private List<ProvenancedTerm> getIRIsWithConditions(Record record, Term triplesMap, List<MultipleRecordsFunctionExecutor> conditions) throws Exception {
        ArrayList<ProvenancedTerm> goodIRIs = new ArrayList<ProvenancedTerm>();
        ArrayList<List<ProvenancedTerm>> allIRIs = new ArrayList<List<ProvenancedTerm>>();
        for (MultipleRecordsFunctionExecutor condition : conditions) {
            allIRIs.add(this.getIRIsWithTrueCondition(record, triplesMap, condition));
        }
        if (!allIRIs.isEmpty()) {
            goodIRIs.addAll((Collection)allIRIs.get(0));
            for (int i = 1; i < allIRIs.size(); ++i) {
                List list = (List)allIRIs.get(i);
                for (int j = 0; j < goodIRIs.size(); ++j) {
                    if (list.contains(goodIRIs.get(j))) continue;
                    goodIRIs.remove(j);
                    --j;
                }
            }
        }
        return goodIRIs;
    }

    private List<ProvenancedTerm> getIRIsWithTrueCondition(Record child, Term triplesMap, MultipleRecordsFunctionExecutor condition) throws Exception {
        Mapping mapping = this.mappings.get(triplesMap);
        List<Record> records = this.getRecords(triplesMap);
        ArrayList<ProvenancedTerm> iris = new ArrayList<ProvenancedTerm>();
        for (int i = 0; i < records.size(); ++i) {
            Record parent = records.get(i);
            HashMap<String, Record> recordsMap = new HashMap<String, Record>();
            recordsMap.put("child", child);
            recordsMap.put("parent", parent);
            Object expectedBoolean = condition.execute(recordsMap);
            if (expectedBoolean instanceof Boolean) {
                if (!((Boolean)expectedBoolean).booleanValue()) continue;
                ProvenancedTerm subject = this.getSubject(triplesMap, mapping, parent, i);
                iris.add(subject);
                continue;
            }
            logger.warn("The used condition with the Parent Triples Map does not return a boolean.");
        }
        return iris;
    }

    private ProvenancedTerm getSubject(Term triplesMap, Mapping mapping, Record record, int i) throws Exception {
        List<Term> nodes;
        if (!this.subjectCache.containsKey(triplesMap)) {
            this.subjectCache.put(triplesMap, new HashMap());
        }
        if (!this.subjectCache.get(triplesMap).containsKey(i) && !(nodes = mapping.getSubjectMappingInfo().getTermGenerator().generate(record)).isEmpty()) {
            Metadata meta = new Metadata(triplesMap, mapping.getSubjectMappingInfo().getTerm());
            List<Term> targets = mapping.getSubjectMappingInfo().getTargets();
            this.subjectCache.get(triplesMap).put(i, new ProvenancedTerm(nodes.get(0), meta, targets));
        }
        return this.subjectCache.get(triplesMap).get(i);
    }

    private List<ProvenancedTerm> getAllIRIs(Term triplesMap) throws Exception {
        Mapping mapping = this.mappings.get(triplesMap);
        List<Record> records = this.getRecords(triplesMap);
        ArrayList<ProvenancedTerm> iris = new ArrayList<ProvenancedTerm>();
        for (int i = 0; i < records.size(); ++i) {
            Record record = records.get(i);
            ProvenancedTerm subject = this.getSubject(triplesMap, mapping, record, i);
            iris.add(subject);
        }
        return iris;
    }

    private List<Record> getRecords(Term triplesMap) throws Exception {
        if (!this.recordsHolders.containsKey(triplesMap)) {
            this.recordsHolders.put(triplesMap, this.recordsFactory.createRecords(triplesMap, this.rmlStore));
        }
        return this.recordsHolders.get(triplesMap);
    }

    private List<PredicateObjectGraph> combineMultiplePOGs(List<ProvenancedTerm> predicates, List<ProvenancedTerm> objects, List<ProvenancedTerm> graphs) {
        ArrayList<PredicateObjectGraph> results = new ArrayList<PredicateObjectGraph>();
        if (graphs.isEmpty()) {
            graphs.add(null);
        }
        predicates.forEach(p -> objects.forEach(o -> graphs.forEach(g -> results.add(new PredicateObjectGraph((ProvenancedTerm)p, (ProvenancedTerm)o, (ProvenancedTerm)g)))));
        return results;
    }

    public static String getNewBlankNodeID() {
        String temp = "" + blankNodeCounter;
        ++blankNodeCounter;
        return temp;
    }

    public List<Term> getTriplesMaps() {
        return this.initializer.getTriplesMaps();
    }

    public QuadStore getRMLStore() {
        return this.rmlStore;
    }

    public HashMap<Term, QuadStore> getTargets() {
        if (this.targetStores.isEmpty()) {
            return null;
        }
        return this.targetStores;
    }

    public void verifySources(String basepath) throws IOException {
        for (Term triplesMap : this.getTriplesMaps()) {
            List<Term> logicalSources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(triplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
            Term logicalSource = logicalSources.get(0);
            List<Term> sources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null));
            for (Term source : sources) {
                String value = source.getValue();
                if (!(source instanceof Literal)) continue;
                InputStream is = Utils.isRemoteFile(value) ? new RemoteFileAccess(value).getInputStream() : new LocalFileAccess(value, basepath).getInputStream();
                is.close();
            }
        }
    }
}

