/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.dataType;

import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterException;
import be.ugent.idlab.knows.functions.agent.dataType.DefaultDataTypeConverter;
import java.lang.reflect.Array;
import java.util.Collection;
import lombok.Generated;

public class ArrayConverter
extends DataTypeConverter<Object[]> {
    private DataTypeConverter<?> argumentTypeConverter = new DefaultDataTypeConverter();

    public ArrayConverter() {
        super(Object[].class, DataTypeConverter.TypeCategory.COLLECTION);
    }

    public void setArgumentTypeConverter(DataTypeConverter<?> argumentTypeConverter) {
        this.argumentTypeConverter = argumentTypeConverter;
        Object[] typeArray = this.initArray(0);
        this.setTypeClass(typeArray.getClass());
    }

    @Override
    public Object[] convert(Object value) throws DataTypeConverterException {
        if (value.getClass().isArray()) {
            return (Object[])value;
        }
        if (value instanceof Collection) {
            return this.convertArray((Collection)value);
        }
        throw new DataTypeConverterException("Cannot convert object of type " + value.getClass().getName() + " to an array.");
    }

    private Object[] convertArray(Collection<?> value) throws DataTypeConverterException {
        Object[] result = this.initArray(value.size());
        Object[] valueArr = value.toArray();
        for (int i = 0; i < valueArr.length; ++i) {
            Object o = valueArr[i];
            result[i] = this.getArgumentTypeConverter().convert(o);
        }
        return result;
    }

    private Object[] initArray(int length) {
        Class<?> componentTypeClass = this.getArgumentTypeConverter().getTypeClass();
        return (Object[])Array.newInstance(componentTypeClass, length);
    }

    @Generated
    public DataTypeConverter<?> getArgumentTypeConverter() {
        return this.argumentTypeConverter;
    }
}

