/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import java.util.ArrayList;
import java.util.Objects;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;

public class XMLRecord
extends Record {
    private final XdmItem item;
    private final XPathCompiler compiler;
    private final int index;

    public XMLRecord(XdmItem item, XPathCompiler compiler, int index) {
        this.item = item;
        this.compiler = compiler;
        this.index = index;
    }

    @Override
    public RecordValue get(String reference) {
        try {
            XdmValue result = this.compiler.evaluate(reference, this.item);
            if (result.isEmpty()) {
                return RecordValue.empty();
            }
            ArrayList results = new ArrayList();
            result.forEach(node -> results.add(node.getStringValue()));
            return RecordValue.ok(results);
        }
        catch (SaxonApiException e1) {
            return RecordValue.error(e1.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XMLRecord xmlRecord = (XMLRecord)o;
        return this.itemEquals(xmlRecord.item);
    }

    private boolean itemEquals(XdmItem item) {
        return this.item.getStringValue().matches(item.getStringValue());
    }

    public int hashCode() {
        return Objects.hash(this.item, this.compiler);
    }

    public XdmItem getItem() {
        return this.item;
    }

    public int getIndex() {
        return this.index;
    }
}

