/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Status;
import java.util.Objects;

public class RecordValue {
    private final Status status;
    private final Object value;
    private final String message;

    private RecordValue(Status status, Object value, String message) {
        this.status = status;
        this.value = value;
        this.message = message;
    }

    public static RecordValue empty() {
        return new RecordValue(Status.EMPTY, null, null);
    }

    public static RecordValue ok(Object value) {
        return new RecordValue(Status.OK, value, null);
    }

    public static RecordValue notFound(String message) {
        return new RecordValue(Status.NOT_FOUND, null, message);
    }

    public static RecordValue error(String message) {
        return new RecordValue(Status.ERROR, null, message);
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public boolean isError() {
        return this.status == Status.ERROR;
    }

    public boolean isEmpty() {
        return this.status == Status.EMPTY;
    }

    public boolean isNotFound() {
        return this.status == Status.NOT_FOUND;
    }

    public Object getValue() {
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordValue that = (RecordValue)o;
        return this.status == that.status && Objects.equals(this.value, that.value) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.value, this.message});
    }
}

