/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVRecord
extends Record {
    private final Map<String, String> data;
    private final Map<String, String> datatypes;

    public CSVRecord(String[] header, String[] data, Map<String, String> datatypes) {
        this.data = new HashMap<String, String>(header.length);
        if (header.length > data.length) {
            this.logger.warn("Header has more columns than this row");
        }
        if (header.length < data.length) {
            this.logger.warn("Header has less columns than this row, these extra values will be ignored");
        }
        for (int i = 0; i < header.length; ++i) {
            if (i < data.length) {
                this.data.put(header[i], data[i]);
                continue;
            }
            this.data.put(header[i], null);
        }
        this.datatypes = datatypes;
    }

    @Override
    public String getDataType(String value) {
        String datatype = null;
        if (this.datatypes != null && (datatype = this.datatypes.get(value)) == null) {
            value = value.replaceFirst("^\"", "").replaceFirst("\"$", "");
            value = value.replaceFirst("^'", "").replaceFirst("'$", "");
            datatype = this.datatypes.get(value);
        }
        return datatype;
    }

    @Override
    public Map<String, String> getDataTypes() {
        return this.datatypes;
    }

    @Override
    public RecordValue get(String reference) {
        String toDatabaseCase = this.data.containsKey(reference.toUpperCase()) ? reference.toUpperCase() : (this.data.containsKey(reference.toLowerCase()) ? reference.toLowerCase() : reference);
        if (!this.data.containsKey(toDatabaseCase)) {
            return RecordValue.notFound(String.format("Mapping for %s not found, expected one of %s", toDatabaseCase, this.data.keySet()));
        }
        String obj = this.data.get(toDatabaseCase);
        if (obj == null) {
            return RecordValue.empty();
        }
        return RecordValue.ok(obj);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSVRecord csvRecord = (CSVRecord)o;
        if (!this.data.equals(csvRecord.data)) {
            return false;
        }
        return this.datatypes.equals(csvRecord.datatypes);
    }

    public int hashCode() {
        int result = this.data.hashCode();
        result = 31 * result + this.datatypes.hashCode();
        return result;
    }

    public String toCSVString() throws IOException {
        int size = this.data.size();
        String[] header = new String[size];
        String[] data = new String[size];
        List keys = this.data.keySet().stream().toList();
        for (int i = 0; i < size; ++i) {
            String key;
            header[i] = key = (String)keys.get(i);
            data[i] = this.data.get(key);
        }
        StringWriter sw = new StringWriter();
        try (CSVWriter writer = new CSVWriter((Writer)sw);){
            writer.writeAll(List.of(header, data));
        }
        return sw.toString();
    }
}

