/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.iterators.csvw.CSVWConfiguration;
import be.ugent.idlab.knows.dataio.record.CSVRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.utils.NewCSVNullInjector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.simpleflatmapper.lightningcsv.CsvParser;

public class CSVWSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = -5824558388620967495L;
    private static final int BUFFER_SIZE = 131072;
    private final Access access;
    private final CSVWConfiguration config;
    private transient String[] header;
    private transient String[] next;
    private transient Iterator<String[]> iterator;
    private int index = -1;

    public CSVWSourceIterator(Access access, CSVWConfiguration config) throws SQLException, IOException, ParserConfigurationException, TransformerException {
        this.access = access;
        this.config = config;
        this.bootstrap();
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException, SQLException, ParserConfigurationException, TransformerException {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    private void bootstrap() throws SQLException, IOException, ParserConfigurationException, TransformerException {
        NewCSVNullInjector injector = new NewCSVNullInjector(this.access.getInputStream(), this.config.getDelimiter(), Character.valueOf(this.config.getQuoteCharacter()), this.config.getEncoding());
        CsvParser.DSL parser = this.config.getSFMParser(131072);
        this.iterator = parser.iterator((Reader)new InputStreamReader((InputStream)injector, StandardCharsets.UTF_8));
        this.header = this.config.isSkipHeader() ? this.config.getHeader().toArray(new String[0]) : this.nextLine();
        this.next = this.nextLine();
    }

    private String[] nextLine() {
        if (this.iterator.hasNext()) {
            String[] r = this.iterator.next();
            while (r[0].startsWith(this.config.getCommentPrefix()) && this.iterator.hasNext()) {
                r = this.iterator.next();
            }
            if (r[0].startsWith(this.config.getCommentPrefix())) {
                return null;
            }
            for (int i = 0; i < r.length; ++i) {
                String s = r[i];
                if (s.startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                }
                r[i] = s = s.replaceAll("\"\"", "\"");
            }
            return r;
        }
        return null;
    }

    public CSVRecord replaceNulls(CSVRecord record) {
        Map<String, String> data = record.getData();
        data.forEach((key, value) -> {
            if (value == null || value.startsWith("DATAIO_NULL") || this.config.getNulls().contains(value)) {
                data.put((String)key, (String)null);
            }
        });
        return record;
    }

    public String[] applyTrimArray(String[] arr, String trim) {
        return (String[])Arrays.stream(arr).map(item -> this.applyTrim((String)item, trim)).toArray(String[]::new);
    }

    public String applyTrim(String item, String trim) {
        return switch (trim) {
            case "true" -> item.trim();
            case "false" -> item;
            case "start" -> item.stripLeading();
            case "end" -> item.stripTrailing();
            default -> throw new IllegalArgumentException("Unrecognized value for flag \"trim\"");
        };
    }

    @Override
    public Record next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String[] line = this.next;
        this.next = this.nextLine();
        if (!this.config.getTrim().equals("false")) {
            line = this.applyTrimArray(line, this.config.getTrim());
        }
        ++this.index;
        return this.replaceNulls(new CSVRecord(this.header, line, this.access.getDataTypes()));
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public int getIndex() {
        return this.index;
    }
}

