/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.utils.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLEndpointAccess
implements Access {
    private static final Logger log = LoggerFactory.getLogger(SPARQLEndpointAccess.class);
    private static final long serialVersionUID = 7331603102049875880L;
    private final String contentType;
    private final String endpoint;
    private final String query;

    public SPARQLEndpointAccess(String contentType, String endpoint, String query) {
        this.contentType = contentType;
        this.endpoint = endpoint;
        this.query = query;
    }

    public static String cleanQuery(String query) {
        return query.replaceAll("[\r\n]+", " ").trim();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = new URL(this.endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", this.contentType);
        HashMap<String, String> urlParams = new HashMap<String, String>(){
            {
                this.put("query", SPARQLEndpointAccess.this.query);
            }
        };
        connection.setDoOutput(true);
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            out.writeBytes(Utils.getURLParamsString((Map<String, String>)urlParams));
        }
        int status = connection.getResponseCode();
        log.debug("Status code for getting InputStream for remote location [{}]: {}", (Object)this.endpoint, (Object)status);
        return connection.getInputStream();
    }

    public boolean equals(Object o) {
        if (o instanceof SPARQLEndpointAccess) {
            SPARQLEndpointAccess access = (SPARQLEndpointAccess)o;
            return this.endpoint.equals(access.getEndpoint()) && this.contentType.equals(access.getContentType()) && this.query.equals(access.getQuery());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getEndpoint() + this.getQuery() + this.getContentType());
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccessPath() {
        return this.endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getQuery() {
        return this.query;
    }
}

