/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class NewCSVNullInjector
extends InputStream {
    public static final String NULL_VALUE = "DATAIO_NULL";
    public long NULL_VALUE_COUNTER = 0L;
    private final BufferedReader reader;
    private final char delimiter;
    private final Character quoteChar;
    private byte[] currentLine;
    private boolean firstLine = true;
    private int pos = 0;
    private boolean insideQuote = false;

    public NewCSVNullInjector(InputStream in, char delimiter, Character quoteChar, Charset charset) {
        this.reader = new BufferedReader(new InputStreamReader(in, charset));
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.currentLine = new byte[0];
    }

    @Override
    public int read() throws IOException {
        if (this.currentLine.length == this.pos) {
            String nextLine = this.reader.readLine();
            if (nextLine == null) {
                return -1;
            }
            this.currentLine = this.replaceNulls(nextLine).getBytes(StandardCharsets.UTF_8);
            this.pos = 0;
            if (!this.firstLine) {
                return 10;
            }
            this.firstLine = false;
        }
        return this.currentLine[this.pos++];
    }

    String replaceNulls(String input) {
        char[] inputChars;
        if (input.isEmpty() && !this.insideQuote) {
            return this.nullValue();
        }
        StringBuilder result = new StringBuilder();
        boolean checkQuotes = this.quoteChar != null;
        block3: for (char inputChar : inputChars = input.toCharArray()) {
            switch (inputChar) {
                case '\ufeff': 
                case '\uffef': {
                    continue block3;
                }
                default: {
                    if (this.insideQuote) {
                        if (checkQuotes && inputChar == this.quoteChar.charValue()) {
                            this.insideQuote = false;
                        }
                    } else if (inputChar == this.delimiter) {
                        if (result.isEmpty() || result.charAt(result.length() - 1) == this.delimiter) {
                            result.append(this.nullValue());
                        }
                    } else if (checkQuotes && inputChar == this.quoteChar.charValue()) {
                        this.insideQuote = true;
                    }
                    result.append(inputChar);
                }
            }
        }
        if (!this.insideQuote && result.charAt(result.length() - 1) == this.delimiter) {
            result.append(this.nullValue());
        }
        return result.toString();
    }

    private String nullValue() {
        ++this.NULL_VALUE_COUNTER;
        return "DATAIO_NULL_" + this.NULL_VALUE_COUNTER;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

