/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.exceptions.UnequalHeaderRowLengthException;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;

public class ODSRecord
extends Record {
    private final Map<String, Cell> values = new HashMap<String, Cell>();

    public ODSRecord(Row header, Row row) {
        if (header.getCellCount() != row.getCellCount()) {
            throw new UnequalHeaderRowLengthException(header.toString(), row.toString());
        }
        for (int i = 0; i < header.getCellCount(); ++i) {
            Cell headerCell = header.getCellByIndex(i);
            Cell valueCell = row.getCellByIndex(i);
            this.values.put(headerCell.getStringValue(), valueCell);
        }
    }

    private static Object getValueFromCell(Cell cell) {
        Object out = switch (cell.getValueType()) {
            case "boolean" -> cell.getBooleanValue();
            case "float" -> {
                Double d = cell.getDoubleValue();
                if (d % 1.0 == 0.0) {
                    yield d.intValue();
                }
                yield d;
            }
            default -> cell.getStringValue();
        };
        out = String.valueOf(out);
        return out;
    }

    @Override
    public RecordValue get(String reference) {
        Cell cell = this.values.get(reference);
        if (cell == null) {
            return RecordValue.notFound("Cell not found for reference: " + reference);
        }
        if (cell.getValueType() == null) {
            return RecordValue.empty();
        }
        return RecordValue.ok(ODSRecord.getValueFromCell(cell));
    }

    @Override
    public String getDataType(String reference) {
        Cell cell = this.values.get(reference);
        if (cell == null) {
            return null;
        }
        switch (cell.getValueType()) {
            case "boolean": {
                return XSDDatatype.XSDboolean.getURI();
            }
            case "float": {
                double d = cell.getDoubleValue();
                if (d % 1.0 == 0.0) {
                    return XSDDatatype.XSDinteger.getURI();
                }
                return XSDDatatype.XSDdouble.getURI();
            }
        }
        return XSDDatatype.XSDstring.getURI();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODSRecord that = (ODSRecord)o;
        for (Map.Entry<String, Cell> e : this.values.entrySet()) {
            Cell thatCell;
            Cell thisCell = e.getValue();
            if (this.cellEquals(thisCell, thatCell = that.values.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean cellEquals(Cell cell, Cell otherCell) {
        return cell.getValueType().equals(otherCell.getValueType()) && cell.getStringValue().equals(otherCell.getStringValue());
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

