/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.access.VirtualAccess;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.JSONRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.jayway.jsonpath.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonSurfer;
import org.jsfr.json.JsonSurferJackson;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.SurfingConfiguration;

public class JSONSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = 5727357114356164542L;
    private final Access access;
    private final String iterationPath;
    private transient ResumableParser parser;
    private transient InputStream inputStream;
    private transient String currentPath;
    private transient Object match = null;
    private boolean hasMatch = false;

    public JSONSourceIterator(Access access, String iterationPath) throws Exception {
        this.access = access;
        this.iterationPath = iterationPath.replaceAll("\\.\\[", "[");
        this.bootstrap();
    }

    public JSONSourceIterator(String json, String iterationPath) throws Exception {
        this(new VirtualAccess(json.getBytes()), iterationPath);
    }

    public static Object getDocumentFromStream(InputStream stream) {
        return Configuration.defaultConfiguration().jsonProvider().parse(stream, "utf-8");
    }

    private void bootstrap() throws Exception {
        this.inputStream = this.access.getInputStream();
        JsonSurfer surfer = JsonSurferJackson.INSTANCE;
        SurfingConfiguration config = surfer.configBuilder().bind(this.iterationPath, new JsonPathListener[]{(value, context) -> {
            this.match = value;
            this.currentPath = context.getJsonPath();
            this.hasMatch = true;
            context.pause();
        }}).build();
        this.parser = surfer.createResumableParser(this.inputStream, config);
        this.parser.parse();
    }

    private void readObject(ObjectInputStream inputStream) throws Exception {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    @Override
    public boolean hasNext() {
        return this.hasMatch || this.parser.resume() && this.hasMatch;
    }

    @Override
    public Record next() {
        if (this.hasNext()) {
            Object match = this.match;
            String path = this.currentPath;
            this.match = null;
            this.currentPath = null;
            this.hasMatch = false;
            if (!(match instanceof ValueNode)) {
                ObjectMapper mapper = new ObjectMapper();
                match = mapper.convertValue(match, Map.class);
            }
            return new JSONRecord(match, this.iterationPath, path);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

