/*
 * Decompiled with CFR 0.152.
 */
package be.sigmadelta.zippitylib;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lbe/sigmadelta/zippitylib/Zippity;", "", "()V", "Companion", "zippitylib_release"})
public final class Zippity {
    @NotNull
    public static final String TAG = "Zippity";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0003J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nH\u0007J\u001e\u0010\u0010\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0012\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbe/sigmadelta/zippitylib/Zippity$Companion;", "", "()V", "TAG", "", "unzip", "", "zipFile", "Ljava/util/zip/ZipFile;", "destDir", "Ljava/io/File;", "writeFileToZip", "out", "Ljava/util/zip/ZipOutputStream;", "file", "baseLineUrl", "zip", "directoryToZip", "outputZip", "files", "", "zippitylib_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unzip(@NotNull ZipFile zipFile, @NotNull File destDir) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
            Intrinsics.checkParameterIsNotNull((Object)destDir, (String)"destDir");
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zipFile.entries()");
            Enumeration<? extends ZipEntry> enumeration2 = enumeration;
            Sequence $receiver$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
            for (Object element$iv : $receiver$iv) {
                ZipEntry it;
                ZipEntry zipEntry = it = (ZipEntry)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"it");
                File subFile = new File(destDir, zipEntry.getName());
                subFile.getParentFile().mkdirs();
                if (it.isDirectory()) continue;
                Closeable closeable = new BufferedInputStream(zipFile.getInputStream(it));
                Throwable throwable = null;
                try {
                    long l;
                    BufferedInputStream orig = (BufferedInputStream)closeable;
                    Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(subFile));
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream dest = (BufferedOutputStream)closeable2;
                        l = ByteStreamsKt.copyTo$default((InputStream)orig, (OutputStream)dest, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zip(@NotNull List<? extends File> files, @NotNull File outputZip) throws IOException, FileNotFoundException {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Intrinsics.checkParameterIsNotNull((Object)outputZip, (String)"outputZip");
            if (files.isEmpty()) {
                return;
            }
            String string = files.get(0).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"files[0].absolutePath");
            String string2 = files.get(0).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"files[0].name");
            String baseLineUrl = StringsKt.removeSuffix((String)string, (CharSequence)string2);
            Closeable closeable = new FileOutputStream(outputZip);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutStream = (FileOutputStream)closeable;
                try {
                    Closeable closeable2 = new ZipOutputStream(new BufferedOutputStream(fileOutStream));
                    Throwable throwable2 = null;
                    try {
                        ZipOutputStream out = (ZipOutputStream)closeable2;
                        Iterable $receiver$iv = files;
                        for (Object element$iv : $receiver$iv) {
                            File it = (File)element$iv;
                            Companion.writeFileToZip(out, it, baseLineUrl);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                catch (IOException e) {
                    outputZip.delete();
                    throw (Throwable)e;
                }
                catch (RuntimeException e) {
                    outputZip.delete();
                    throw (Throwable)e;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public final void zip(@NotNull String directoryToZip, @NotNull File outputZip) throws IOException, FileNotFoundException, IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull((Object)directoryToZip, (String)"directoryToZip");
            Intrinsics.checkParameterIsNotNull((Object)outputZip, (String)"outputZip");
            File dirFile = new File(directoryToZip);
            if (!dirFile.exists() || !dirFile.isDirectory()) {
                throw (Throwable)new IllegalArgumentException("Invalid directory specified: " + directoryToZip);
            }
            File[] fileArray = dirFile.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"dirFile.listFiles()");
            this.zip(ArraysKt.toList((Object[])fileArray), outputZip);
        }

        private final void writeFileToZip(ZipOutputStream out, File file, String baseLineUrl) throws IOException {
            StringBuilder stringBuilder = new StringBuilder().append("file: ");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            Log.d((String)Zippity.TAG, (String)stringBuilder.append(StringsKt.removePrefix((String)string, (CharSequence)baseLineUrl)).toString());
            if (file.isFile()) {
                String string2 = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.absolutePath");
                ZipEntry zipEntry = new ZipEntry(StringsKt.removePrefix((String)string2, (CharSequence)baseLineUrl));
                out.putNextEntry(zipEntry);
                out.write(FilesKt.readBytes((File)file));
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"file.listFiles()");
                for (Object element$iv : (Object[])fileArray) {
                    File subFile;
                    File file2 = subFile = (File)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"subFile");
                    String string3 = file2.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"subFile.absolutePath");
                    ZipEntry zipEntry = new ZipEntry(StringsKt.removePrefix((String)string3, (CharSequence)baseLineUrl));
                    out.putNextEntry(zipEntry);
                    out.write(FilesKt.readBytes((File)subFile));
                }
            }
            out.closeEntry();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

