/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.ScatterLineData;
import be.ceau.chart.dataset.ScatterLineDataset;
import be.ceau.chart.options.LineOptions;
import be.ceau.chart.options.scales.LinearScale;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class ScatterLineChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(ScatterLineChart.class);
    private final String type = "line";
    private ScatterLineData data;
    private LineOptions options;

    public static ScatterLineData data() {
        return new ScatterLineData();
    }

    public static LineOptions options() {
        return new LineOptions();
    }

    public ScatterLineChart() {
    }

    public ScatterLineChart(ScatterLineData data) {
        this.data = data;
    }

    public ScatterLineChart(ScatterLineData data, LineOptions options) {
        this.data = data;
        this.options = options;
    }

    @Override
    public String getType() {
        return "line";
    }

    public ScatterLineData getData() {
        return this.data;
    }

    public ScatterLineChart setData(ScatterLineData data) {
        this.data = data;
        return this;
    }

    public LineOptions getOptions() {
        return this.options;
    }

    public ScatterLineChart setOptions(LineOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        boolean sufficientData = false;
        for (ScatterLineDataset dataset : this.data.getDatasets()) {
            if (dataset.getXAxisID() != null && !this.hasXAxisWithId(dataset.getXAxisID())) {
                return false;
            }
            if (dataset.getYAxisID() != null && !this.hasYAxisWithId(dataset.getYAxisID())) {
                return false;
            }
            if (dataset.getData().size() <= 0) continue;
            sufficientData = true;
        }
        return sufficientData;
    }

    private boolean hasXAxisWithId(String id) {
        if (this.options != null && this.options.getScales() != null && this.options.getScales().getxAxes() != null) {
            for (LinearScale xAxis : this.options.getScales().getxAxes()) {
                if (!id.equals(xAxis.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasYAxisWithId(String id) {
        if (this.options != null && this.options.getScales() != null && this.options.getScales().getyAxes() != null) {
            for (LinearScale yAxis : this.options.getScales().getyAxes()) {
                if (!id.equals(yAxis.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

