/*
 * Decompiled with CFR 0.152.
 */
package be.appfoundry.progressbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import be.appfoundry.progressbutton.R;
import be.appfoundry.progressbutton.util.CircularOutline;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class ProgressButton
extends View {
    private static final float DEFAULT_MAX_PROGRESS = 100.0f;
    private static final float DEFAULT_ANIMATION_STEP = 1.0f;
    private static final int DEFAULT_START_DEGREES = 270;
    private static final int DEFAULT_ANIMATION_DELAY = 0;
    private static final float DEFAULT_STROKE_WIDTH = 20.0f;
    private static final int MAX_DEGREES = 360;
    private static final int MIN_SIZE = 48;
    private static final int DEFAULT_COLOR_PRIMARY = -1;
    private static final int DEFAULT_COLOR_PRIMARY_DARK = 0x33000000;
    private static final int DEFAULT_COLOR_ACCENT = -16777216;
    private int color;
    private int strokeColor;
    private int progressColor;
    private float strokeWidth;
    private float maxProgress = 100.0f;
    private float animationStep = 1.0f;
    private boolean indeterminate;
    private boolean reverse = false;
    private Drawable icon;
    private float radius;
    private float progress;
    private boolean isAnimating = false;
    private float startDegrees = 270.0f;
    private float startingPoint = 270.0f;
    private int animationDelay = 0;
    private Paint circlePaint;
    private Paint progressPaint;
    private Paint strokePaint;
    private float degrees;
    private Handler animationHandler = new AnimationHandler(this);
    RectF buttonRectF = new RectF();
    Rect iconRect = new Rect();
    private int colorPrimary = -1;
    private int colorPrimaryDark = 0x33000000;
    private int colorAccent = -16777216;

    public ProgressButton(Context context) {
        this(context, null);
        this.init(context, null);
    }

    public ProgressButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.init(context, attrs);
    }

    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.circlePaint = new Paint(1);
        this.progressPaint = new Paint(1);
        this.strokePaint = new Paint(1);
        Resources.Theme theme = context.getTheme();
        TypedArray attr2 = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressButton, 0, 0);
        TypedValue value = new TypedValue();
        if (Build.VERSION.SDK_INT >= 21) {
            this.initColorsLollipop(context, theme, value);
        } else if (Build.VERSION.SDK_INT >= 16) {
            this.initColorsJellyBean(context, theme, value);
        }
        try {
            this.color = attr2.getColor(R.styleable.ProgressButton_fillColor, this.colorPrimary);
            this.circlePaint.setColor(this.color);
            this.strokeColor = attr2.getColor(R.styleable.ProgressButton_strokeColor, this.colorPrimaryDark);
            this.strokePaint.setColor(this.strokeColor);
            this.progressColor = attr2.getColor(R.styleable.ProgressButton_progressColor, this.colorAccent);
            this.progressPaint.setColor(this.progressColor);
            this.strokeWidth = attr2.getDimension(R.styleable.ProgressButton_strokeWidth, 20.0f);
            this.indeterminate = attr2.getBoolean(R.styleable.ProgressButton_indeterminate, true);
            this.icon = attr2.getDrawable(R.styleable.ProgressButton_progressIcon);
        }
        finally {
            attr2.recycle();
        }
    }

    @TargetApi(value=21)
    private void initColorsLollipop(Context context, Resources.Theme theme, TypedValue value) {
        theme.resolveAttribute(16843827, value, true);
        this.colorPrimary = value.data;
        theme.resolveAttribute(16843828, value, true);
        this.colorPrimaryDark = value.data;
        theme.resolveAttribute(16843829, value, true);
        this.colorAccent = value.data;
    }

    @TargetApi(value=16)
    private void initColorsJellyBean(Context context, Resources.Theme theme, TypedValue value) {
        theme.resolveAttribute(2130772086, value, true);
        this.colorPrimary = value.data;
        theme.resolveAttribute(2130772087, value, true);
        this.colorPrimaryDark = value.data;
        theme.resolveAttribute(2130772088, value, true);
        this.colorAccent = value.data;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.invalidate();
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (progress > this.maxProgress || progress < 0.0f) {
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "Progress (%d) must be between %d and %d", Float.valueOf(progress), 0, Float.valueOf(this.maxProgress)));
        }
        this.progress = progress;
        this.degrees = 360.0f * progress / this.maxProgress;
        this.invalidate();
    }

    public float getStartDegrees() {
        return this.startDegrees;
    }

    public void setStartDegrees(float degrees) {
        this.startDegrees = degrees;
        this.startingPoint = degrees;
        this.invalidate();
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public void setIcon(@IdRes Drawable icon) {
        this.icon = icon;
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(@ColorInt int color) {
        this.color = color;
        this.circlePaint.setColor(color);
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(@ColorInt int strokeColor) {
        this.strokeColor = strokeColor;
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(@ColorInt int progressColor) {
        this.progressColor = progressColor;
        this.progressPaint.setColor(progressColor);
        this.invalidate();
    }

    public float getAnimationStep() {
        return this.animationStep;
    }

    public void setAnimationStep(float animationStep) {
        this.animationStep = animationStep;
    }

    public float getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        int width = this.getLayoutParams().width;
        int height = this.getLayoutParams().height;
        int getWidth = this.getWidth();
        int getHeight = this.getHeight();
        int resolvedWidth = ProgressButton.resolveSize((int)getWidth, (int)widthMeasureSpec);
        int resolvedHeight = ProgressButton.resolveSize((int)getHeight, (int)heightMeasureSpec);
        int size = this.calculateSize(resolvedWidth, resolvedHeight, width, height);
        this.setMeasuredDimension(size, size);
    }

    private int calculateSize(int resolvedWidth, int resolvedHeight, int width, int height) {
        int size;
        if (this.radius > 0.0f) {
            size = (int)(this.radius * 2.0f);
        } else if (this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1) {
            size = resolvedWidth;
            if (size > resolvedHeight) {
                size = resolvedHeight;
            }
        } else {
            size = this.getLayoutParams().width == -1 && this.getLayoutParams().height != -1 ? resolvedHeight : (this.getLayoutParams().height == -1 && this.getLayoutParams().width != -1 ? resolvedWidth : (this.getLayoutParams().width == -2 && this.getLayoutParams().height == -2 ? (int)ProgressButton.convertDpToPixel(this.getContext(), 48.0f) : (this.getLayoutParams().width == -2 && this.getLayoutParams().height != -2 ? resolvedHeight : (this.getLayoutParams().height == -2 && this.getLayoutParams().width != -2 ? resolvedWidth : (width > height ? resolvedHeight : (width < height ? resolvedWidth : this.calculateDefaultSize(resolvedWidth, resolvedHeight, width, height)))))));
        }
        return size;
    }

    private int calculateDefaultSize(int resolvedWidth, int resolvedHeight, int width, int height) {
        int size;
        if (resolvedHeight == 0) {
            size = width;
            if (size > resolvedWidth) {
                size = resolvedWidth;
            }
        } else if (resolvedWidth == 0) {
            size = height;
            if (size > resolvedHeight) {
                size = resolvedHeight;
            }
        } else {
            size = resolvedWidth;
            if (size > resolvedHeight) {
                size = resolvedHeight;
            }
        }
        return size;
    }

    private static float convertDpToPixel(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new CircularOutline(width, height));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.radius == 0.0f) {
            this.radius = this.getWidth() / 2;
        }
        float left = (float)(this.getWidth() / 2) - this.radius;
        float right = (float)(this.getWidth() / 2) + this.radius;
        float top = (float)(this.getHeight() / 2) - this.radius;
        float bottom = (float)(this.getHeight() / 2) + this.radius;
        this.buttonRectF.set(left, top, right, bottom);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius, this.strokePaint);
        canvas.drawArc(this.buttonRectF, this.startingPoint, this.degrees, true, this.progressPaint);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius - this.strokeWidth, this.circlePaint);
        if (this.icon != null) {
            this.iconRect.set(0, 0, (int)this.radius, (int)this.radius);
            this.iconRect.offset((this.getWidth() - (int)this.radius) / 2, (this.getHeight() - (int)this.radius) / 2);
            this.icon.setBounds(this.iconRect);
            this.icon.draw(canvas);
        }
    }

    private void setProgressStart(float progress, float startDegrees) {
        this.progress = progress;
        this.startingPoint = startDegrees;
        this.degrees = 360.0f * progress / this.maxProgress;
        this.invalidate();
    }

    public void startAnimating() {
        if (this.indeterminate && !this.isAnimating) {
            this.isAnimating = true;
            this.animationHandler.sendEmptyMessage(0);
        }
    }

    public void stopAnimating() {
        if (this.isAnimating) {
            this.animationHandler.removeMessages(0);
            this.progress = 0.0f;
            this.reverse = false;
            this.startingPoint = this.startDegrees;
            this.setProgressStart(this.progress, this.startingPoint);
            this.isAnimating = false;
            this.invalidate();
        }
    }

    private void handleAnimation() {
        if (this.indeterminate) {
            if (this.progress >= this.maxProgress) {
                this.reverse = true;
                this.startingPoint = this.startDegrees;
                this.progress = this.maxProgress;
            } else if (this.progress <= 0.0f) {
                this.reverse = false;
                this.startingPoint = this.startDegrees;
                this.progress = 0.0f;
            }
            if (this.reverse) {
                float degrees1 = 360.0f * this.progress / this.maxProgress;
                this.progress -= this.animationStep;
                float degrees2 = 360.0f * this.progress / this.maxProgress;
                float diff = degrees1 - degrees2;
                this.startingPoint += diff;
            } else {
                this.progress += this.animationStep;
            }
            this.setProgressStart(this.progress, this.startingPoint);
            this.animationHandler.sendEmptyMessageDelayed(0, (long)this.animationDelay);
        }
    }

    static class AnimationHandler
    extends Handler {
        private final WeakReference<ProgressButton> progressButtonReference;

        AnimationHandler(ProgressButton progressButton) {
            this.progressButtonReference = new WeakReference<ProgressButton>(progressButton);
        }

        public void handleMessage(Message msg) {
            ProgressButton progressButton = (ProgressButton)((Object)this.progressButtonReference.get());
            if (progressButton != null) {
                progressButton.handleAnimation();
            }
        }
    }
}

