/*
 * Decompiled with CFR 0.152.
 */
package at.caseapps.matcha.tests;

import at.caseapps.matcha.Action;
import at.caseapps.matcha.ScannerUtils;
import at.caseapps.matcha.Scenario;
import at.caseapps.matcha.TestCase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Scanner {
    public TestCase testCase;

    public Scanner(InputStream inputStream, String fileName) throws IOException {
        String line;
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        Scenario currentScenario = null;
        ArrayList<Action> currentPreconditions = null;
        ArrayList<Action> currentSteps = null;
        String currentParameterLines = null;
        String currentActionName = null;
        String currentFirstParameter = null;
        Integer lineNumber = null;
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            String trimmedLine = line.trim();
            lineNumber = lineNumber == null ? Integer.valueOf(1) : Integer.valueOf(lineNumber + 1);
            if (trimmedLine.isEmpty()) continue;
            if (currentParameterLines != null) {
                currentParameterLines = currentParameterLines + trimmedLine;
                if (!trimmedLine.equals("}")) continue;
                Map<String, Object> parameters = this.parseParams(currentParameterLines);
                Action action = Action.createAction(currentActionName, currentFirstParameter, parameters, lineNumber);
                if (currentPreconditions != null) {
                    currentPreconditions.add(action);
                } else if (currentSteps != null) {
                    currentSteps.add(action);
                }
                currentParameterLines = null;
                continue;
            }
            String tcString = this.matches("TestCase:", trimmedLine);
            if (tcString != null) {
                this.testCase = new TestCase(fileName, tcString);
                continue;
            }
            String scenarioString = this.matches("Scenario:", trimmedLine);
            if (scenarioString != null) {
                if (currentPreconditions != null) {
                    currentScenario.preconditions = currentPreconditions;
                }
                if (currentSteps != null) {
                    currentScenario.steps = currentSteps;
                }
                currentScenario = new Scenario(scenarioString);
                scenarios.add(currentScenario);
                continue;
            }
            if (trimmedLine.startsWith("Preconditions:")) {
                if (currentSteps != null) {
                    currentScenario.steps = currentSteps;
                }
                currentSteps = null;
                currentPreconditions = new ArrayList<Action>();
                continue;
            }
            if (trimmedLine.startsWith("Steps:")) {
                if (currentPreconditions != null) {
                    currentScenario.preconditions = currentPreconditions;
                }
                currentSteps = new ArrayList<Action>();
                currentPreconditions = null;
                continue;
            }
            if (!trimmedLine.startsWith("@")) continue;
            ScannerUtils.Pair actionAndParams = ScannerUtils.matcha_splitStep(trimmedLine);
            currentActionName = actionAndParams.first;
            currentFirstParameter = null;
            String value = null;
            Map<String, Object> parameters = new HashMap<String, Object>();
            if (actionAndParams.second != null) {
                boolean isMultiLineParams = false;
                String paramsAsString = actionAndParams.second;
                if (paramsAsString.startsWith("{") && !paramsAsString.endsWith("}")) {
                    currentParameterLines = paramsAsString;
                    continue;
                }
                if (paramsAsString.startsWith("{") && paramsAsString.endsWith("}")) {
                    parameters = this.parseParams(paramsAsString);
                } else if (ScannerUtils.matcha_isValue(paramsAsString)) {
                    value = ScannerUtils.matcha_trimValue(paramsAsString);
                } else {
                    String[] paramsArray = ScannerUtils.matcha_splitToFirstSpace(paramsAsString);
                    if (paramsArray.length > 0) {
                        int i = 0;
                        for (String p1 : paramsArray) {
                            if (i == 0) {
                                currentFirstParameter = p1;
                                ++i;
                                continue;
                            }
                            String trimmedP = p1.trim();
                            if (trimmedP.startsWith("{") && !trimmedP.endsWith("}")) {
                                currentParameterLines = trimmedP;
                                isMultiLineParams = true;
                                break;
                            }
                            if (trimmedP.startsWith("{") && trimmedP.endsWith("}")) {
                                parameters = this.parseParams(trimmedP);
                            } else if (trimmedP.startsWith("'") && trimmedP.endsWith("'") || trimmedP.startsWith("\"") && trimmedP.endsWith("\"")) {
                                value = ScannerUtils.matcha_trimValue(trimmedP);
                            }
                            ++i;
                        }
                    }
                }
                if (isMultiLineParams) continue;
            }
            if (value != null) {
                parameters.put("value", value);
            }
            Action action = Action.createAction(currentActionName, currentFirstParameter, parameters, lineNumber);
            if (currentPreconditions != null) {
                currentPreconditions.add(action);
                continue;
            }
            if (currentSteps == null) continue;
            currentSteps.add(action);
        }
        if (currentPreconditions != null) {
            currentScenario.preconditions = currentPreconditions;
        }
        if (currentSteps != null) {
            currentScenario.steps = currentSteps;
        }
        this.testCase.scenarios = scenarios;
    }

    private String matches(String match, String line) {
        if (line.trim().startsWith(match)) {
            return line.substring(match.length()).trim();
        }
        return null;
    }

    private Map<String, Object> parseParams(String string) {
        String key = "";
        String currentToken = "";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (char c : string.toCharArray()) {
            if (c == '{') continue;
            if (c == ':') {
                key = currentToken.trim();
                currentToken = "";
                continue;
            }
            if (c == '}' || c == ',') {
                String value = ScannerUtils.matcha_trimValue(currentToken);
                parameters.put(key, value.trim());
                currentToken = "";
                continue;
            }
            currentToken = currentToken + c;
        }
        return parameters;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }
}

