/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.attrs.AnnotationMemberValue;

public class Annotation {
    public String type;
    public List memberValues = new ArrayList();

    public void add(String string, Object object) {
        this.memberValues.add(new Object[]{string, object});
    }

    public int read(ClassReader classReader, int n, char[] cArray) {
        this.type = classReader.readClass(n, cArray);
        int n2 = classReader.readUnsignedShort(n + 2);
        n += 4;
        for (int i = 0; i < n2; ++i) {
            String string = classReader.readUTF8(n, cArray);
            AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue();
            n = annotationMemberValue.read(classReader, n + 2, cArray);
            this.memberValues.add(new Object[]{string, annotationMemberValue});
        }
        return n;
    }

    public void write(ByteVector byteVector, ClassWriter classWriter) {
        byteVector.putShort(classWriter.newClass(this.type));
        byteVector.putShort(this.memberValues.size());
        for (int i = 0; i < this.memberValues.size(); ++i) {
            Object[] objectArray = (Object[])this.memberValues.get(i);
            byteVector.putShort(classWriter.newUTF8((String)objectArray[0]));
            ((AnnotationMemberValue)objectArray[1]).write(byteVector, classWriter);
        }
    }

    public static int readAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.readUnsignedShort(n);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            Annotation annotation = new Annotation();
            n = annotation.read(classReader, n, cArray);
            list.add(annotation);
        }
        return n;
    }

    public static void readParameterAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.b[n++] & 0xFF;
        for (int i = 0; i < n2; ++i) {
            ArrayList arrayList = new ArrayList();
            n = Annotation.readAnnotations(arrayList, classReader, n, cArray);
            list.add(arrayList);
        }
    }

    public static ByteVector writeAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putShort(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ((Annotation)list.get(i)).write(byteVector, classWriter);
        }
        return byteVector;
    }

    public static ByteVector writeParametersAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putByte(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Annotation.writeAnnotations(byteVector, (List)list.get(i), classWriter);
        }
        return byteVector;
    }

    public static String stringAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append('\n').append(list.get(i));
            }
        }
        return stringBuffer.toString();
    }

    public static String stringParameterAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(string).append(Annotation.stringAnnotations((List)list.get(i)));
            string = ", ";
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@").append(this.type);
        if (this.memberValues.size() > 0) {
            stringBuffer.append(" ( ");
            String string = "";
            for (int i = 0; i < this.memberValues.size(); ++i) {
                Object[] objectArray = (Object[])this.memberValues.get(i);
                if (this.memberValues.size() != 1 && !"value".equals(this.memberValues.get(0))) {
                    stringBuffer.append(string).append(objectArray[0]).append(" = ");
                }
                stringBuffer.append(objectArray[1]);
                string = ", ";
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }
}

