/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.attrs.AnnotationMemberValue;

public class Annotation {
    public String type;
    public List memberValues = new LinkedList();

    public void add(String string, Object object) {
        this.memberValues.add(new Object[]{string, object});
    }

    public int read(ClassReader classReader, int n, char[] cArray) {
        this.type = classReader.readClass(n, cArray);
        int n2 = classReader.readUnsignedShort(n + 2);
        n += 4;
        int n3 = 0;
        while (n3 < n2) {
            String string = classReader.readUTF8(n, cArray);
            AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue();
            n = annotationMemberValue.read(classReader, n + 2, cArray);
            this.memberValues.add(new Object[]{string, annotationMemberValue});
            ++n3;
        }
        return n;
    }

    public void write(ByteVector byteVector, ClassWriter classWriter) {
        byteVector.putShort(classWriter.newClass(this.type));
        byteVector.putShort(this.memberValues.size());
        int n = 0;
        while (n < this.memberValues.size()) {
            Object[] objectArray = (Object[])this.memberValues.get(n);
            byteVector.putShort(classWriter.newUTF8((String)objectArray[0]));
            ((AnnotationMemberValue)objectArray[1]).write(byteVector, classWriter);
            ++n;
        }
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append("Annotation ").append(string).append(" = new Annotation();\n");
        stringBuffer.append(string).append(".type = \"").append(this.type).append("\";\n");
        if (this.memberValues.size() > 0) {
            stringBuffer.append("{\n");
            int n = 0;
            while (n < this.memberValues.size()) {
                Object[] objectArray = (Object[])this.memberValues.get(n);
                String string2 = string + "val" + n;
                ((AnnotationMemberValue)objectArray[1]).dump(stringBuffer, string2);
                stringBuffer.append(string).append(".add( \"").append(objectArray[0]).append("\", ").append(string2).append(");\n");
                ++n;
            }
            stringBuffer.append("}\n");
        }
    }

    public static int readAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.readUnsignedShort(n);
        n += 2;
        int n3 = 0;
        while (n3 < n2) {
            Annotation annotation = new Annotation();
            n = annotation.read(classReader, n, cArray);
            list.add(annotation);
            ++n3;
        }
        return n;
    }

    public static void readParameterAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.b[n++] & 0xFF;
        int n3 = 0;
        while (n3 < n2) {
            LinkedList linkedList = new LinkedList();
            n = Annotation.readAnnotations(linkedList, classReader, n, cArray);
            list.add(linkedList);
            ++n3;
        }
    }

    public static ByteVector writeAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putShort(list.size());
        int n = 0;
        while (n < list.size()) {
            ((Annotation)list.get(n)).write(byteVector, classWriter);
            ++n;
        }
        return byteVector;
    }

    public static ByteVector writeParametersAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putByte(list.size());
        int n = 0;
        while (n < list.size()) {
            Annotation.writeAnnotations(byteVector, (List)list.get(n), classWriter);
            ++n;
        }
        return byteVector;
    }

    public static void dumpAnnotations(StringBuffer stringBuffer, String string, List list) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            int n = 0;
            while (n < list.size()) {
                String string2 = string + "ann" + n;
                ((Annotation)list.get(n)).dump(stringBuffer, string2);
                stringBuffer.append(string).append(".add( ").append(string2).append(");\n");
                ++n;
            }
            stringBuffer.append("}\n");
        }
    }

    public static void dumpParameterAnnotations(StringBuffer stringBuffer, String string, List list) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            int n = 0;
            while (n < list.size()) {
                String string2 = string + "param" + n;
                Annotation.dumpAnnotations(stringBuffer, string2, (List)list.get(n));
                stringBuffer.append(string).append(".add( ").append(string2).append(");\n");
                ++n;
            }
            stringBuffer.append("}\n");
        }
    }

    public static String stringAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                stringBuffer.append('\n').append(list.get(n));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String stringParameterAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n = 0;
        while (n < list.size()) {
            stringBuffer.append(string).append(Annotation.stringAnnotations((List)list.get(n)));
            string = ", ";
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@").append(this.type);
        if (this.memberValues.size() > 0) {
            stringBuffer.append(" ( ");
            String string = "";
            int n = 0;
            while (n < this.memberValues.size()) {
                Object[] objectArray = (Object[])this.memberValues.get(n);
                if (this.memberValues.size() > 1) {
                    stringBuffer.append(string).append(objectArray[0]).append(" = ");
                }
                stringBuffer.append(objectArray[1]);
                string = ", ";
                ++n;
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }
}

