/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final boolean isInterface;

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type, Type type2, boolean bl) {
        this.currentClass = type;
        this.currentSuperClass = type2;
        this.isInterface = bl;
    }

    public Value newValue(Type type) {
        Value value = super.newValue(type);
        if (value == BasicValue.REFERENCE_VALUE) {
            if (type.getSort() == 9) {
                value = this.newValue(type.getElementType());
                String string = ((BasicValue)value).getType().getDescriptor();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    string = "[" + string;
                }
                value = new BasicValue(Type.getType(string));
            } else {
                value = new BasicValue(type);
            }
        }
        return value;
    }

    protected boolean isArrayValue(Value value) {
        Type type = ((BasicValue)value).getType();
        if (type != null) {
            return type.getDescriptor().equals("Lnull;") || type.getSort() == 9;
        }
        return false;
    }

    protected Value getElementValue(Value value) throws AnalyzerException {
        Type type = ((BasicValue)value).getType();
        if (type != null) {
            if (type.getSort() == 9) {
                return this.newValue(Type.getType(type.getDescriptor().substring(1)));
            }
            if (type.getDescriptor().equals("Lnull;")) {
                return value;
            }
        }
        throw new AnalyzerException("Not an array type");
    }

    protected boolean isSubTypeOf(Value value, Value value2) {
        Type type = ((BasicValue)value2).getType();
        Type type2 = ((BasicValue)value).getType();
        if (type == null) {
            return type2 == null;
        }
        switch (type.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2 == type;
            }
            case 9: 
            case 10: {
                if (type.getDescriptor().equals("Lnull;")) {
                    return type2.getSort() == 10 || type2.getSort() == 9;
                }
                if (type2.getDescriptor().equals("Lnull;")) {
                    return true;
                }
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    return this.isAssignableFrom(type, type2);
                }
                return false;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Value merge(Value value, Value value2) {
        if (!value.equals(value2)) {
            Type type = ((BasicValue)value).getType();
            Type type2 = ((BasicValue)value2).getType();
            if (!(type == null || type.getSort() != 10 && type.getSort() != 9 || type2 == null || type2.getSort() != 10 && type2.getSort() != 9)) {
                if (type.getDescriptor().equals("Lnull;")) {
                    return value2;
                }
                if (type2.getDescriptor().equals("Lnull;")) {
                    return value;
                }
                if (this.isAssignableFrom(type, type2)) {
                    return value;
                }
                if (this.isAssignableFrom(type2, type)) {
                    return value2;
                }
                do {
                    if (type != null && !this.isInterface(type)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(type = this.getSuperClass(type), type2));
                return this.newValue(type);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return value;
    }

    private boolean isInterface(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type).isInterface();
    }

    private Type getSuperClass(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class clazz = this.getClass(type).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    private boolean isAssignableFrom(Type type, Type type2) {
        if (type.equals(type2)) {
            return true;
        }
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.isAssignableFrom(type, this.getSuperClass(type2));
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            return this.isAssignableFrom(type, this.currentSuperClass);
        }
        return this.getClass(type).isAssignableFrom(this.getClass(type2));
    }

    protected Class getClass(Type type) {
        try {
            if (type.getSort() == 9) {
                return Class.forName(type.getDescriptor().replace('/', '.'));
            }
            return Class.forName(type.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }
}

