/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public final class Obfuscater {
    final byte[] salt = new byte[]{35, 66, 16, 55, 8, 119, 85, 25};
    final char[] defaultPassword = new char[]{'t', 'g', 'A', '6', 'Q', 'u', '/', 'g', '1', '8', 'y', 'G', 't', 'L', 'G', 'd', 'z', '4', 'l', 'D', 'v', 'O', 's', 'U', 'J', 'A', 'j', 'o', '9', 'i', 'z', 'o', 'X', 'i', 'g', '8', 'X', 'F', 'E', 'P', 'f', 'l', 'I'};
    final int KEY_LENGTH = 128;
    final int ITERATIONS = 65536;
    final char[] password;

    public Obfuscater(char[] password) {
        this.password = password;
    }

    public Obfuscater() {
        this.password = this.defaultPassword;
    }

    public void clearPassword() {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
    }

    public final String decrypt(String inBase64) {
        byte[] all = DatatypeConverter.parseBase64Binary((String)inBase64);
        byte[] iv = new byte[16];
        System.arraycopy(all, 0, iv, 0, 16);
        byte[] ciphertext = new byte[all.length - 16];
        System.arraycopy(all, 16, ciphertext, 0, all.length - 16);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this.defaultPassword, this.salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return new String(cipher.doFinal(ciphertext), "UTF-8");
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public final byte[] decryptToBytes(String inBase64) {
        byte[] all = DatatypeConverter.parseBase64Binary((String)inBase64);
        byte[] iv = new byte[16];
        System.arraycopy(all, 0, iv, 0, 16);
        byte[] ciphertext = new byte[all.length - 16];
        System.arraycopy(all, 16, ciphertext, 0, all.length - 16);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this.defaultPassword, this.salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return cipher.doFinal(ciphertext);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public final char[] decryptToChar(String inBase64) {
        return this.decryptToChar(inBase64, Charset.forName("UTF-8"));
    }

    public final char[] decryptToChar(String inBase64, Charset charset) {
        byte[] all = DatatypeConverter.parseBase64Binary((String)inBase64);
        byte[] iv = new byte[16];
        System.arraycopy(all, 0, iv, 0, 16);
        byte[] ciphertext = new byte[all.length - 16];
        System.arraycopy(all, 16, ciphertext, 0, all.length - 16);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this.defaultPassword, this.salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(ciphertext);
            ByteBuffer buf = ByteBuffer.wrap(result);
            CharBuffer cBuf = charset.decode(buf);
            return cBuf.array();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public final String encrypt(char[] in, Charset charset) {
        CharBuffer cBuf = CharBuffer.wrap(in);
        ByteBuffer result = charset.encode(cBuf);
        return this.encrypt(result.array());
    }

    public final String encrypt(char[] in) {
        CharBuffer cBuf = CharBuffer.wrap(in);
        ByteBuffer result = Charset.forName("UTF-8").encode(cBuf);
        return this.encrypt(result.array());
    }

    public final String encrypt(byte[] in) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this.defaultPassword, this.salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = cipher.doFinal(in);
            byte[] all = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, all, 0, iv.length);
            System.arraycopy(ciphertext, 0, all, iv.length, ciphertext.length);
            return DatatypeConverter.printBase64Binary((byte[])all);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public final String encrypt(String in) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this.defaultPassword, this.salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = cipher.doFinal(in.getBytes("UTF-8"));
            byte[] all = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, all, 0, iv.length);
            System.arraycopy(ciphertext, 0, all, iv.length, ciphertext.length);
            String body = DatatypeConverter.printBase64Binary((byte[])all);
            return body;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Please provide an argument, the string to be obfuscated");
            return;
        }
        Obfuscater o = new Obfuscater();
        for (String in : args) {
            String s = o.encrypt(in);
            System.out.println(s);
        }
    }
}

