/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EnvResolver {
    Map<String, String> variables = new HashMap<String, String>();
    public static final EnvResolver INSTANCE = new EnvResolver();

    private EnvResolver() {
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            String value = env.get(key);
            this.variables.put(key.toLowerCase(), value);
        }
        Properties systemProps = System.getProperties();
        for (Object key : systemProps.keySet()) {
            String value = systemProps.getProperty(String.valueOf(key));
            this.variables.put(String.valueOf(key).toLowerCase(), value);
        }
    }

    public String get(String key) {
        if (!this.variables.containsKey(key.toLowerCase())) {
            throw new RuntimeException("Missing variable in environment or System props: " + key);
        }
        return this.variables.get(key.toLowerCase());
    }
}

