/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.values;

import asia.redact.bracket.properties.io.OutputFormat;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class Comment
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    public String comments;

    public Comment() {
        this.comments = "";
    }

    public Comment(String line) {
        if (!line.trim().startsWith("#") && !line.trim().startsWith("!")) {
            line = line + "# " + line;
        }
        this.comments = line;
    }

    public Comment addLine(String line) {
        StringBuffer buf = new StringBuffer(this.comments);
        if (buf.length() > 0) {
            buf.append(OutputFormat.lineSeparator);
        }
        if (!line.trim().startsWith("#") && !line.trim().startsWith("!")) {
            buf.append("# ");
        }
        buf.append(line);
        this.comments = buf.toString();
        return this;
    }

    public int size() {
        if (this.comments.length() == 0) {
            return 0;
        }
        return this.comments.split("\\n").length;
    }

    public void clear() {
        this.comments = "";
    }

    public void addAll(List<String> list) {
        for (String line : list) {
            this.addLine(line);
        }
    }

    @Override
    public Iterator<String> iterator() {
        if (this.comments.length() == 0) {
            return new Iter(new String[0]);
        }
        return new Iter(this.comments.split("\\n"));
    }

    public boolean containsUnicodeEscape() {
        return this.comments.contains("\\u");
    }

    private class Iter
    implements Iterator<String> {
        private final String[] comments;
        private int index;

        public Iter(String[] comments) {
            this.comments = comments;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.comments.length;
        }

        @Override
        public String next() {
            int i = this.index++;
            return this.comments[i];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

