/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.values;

import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BasicValueModel
implements ValueModel,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String lineSeparator = System.getProperty("line.separator");
    protected final Comment comments;
    protected final List<String> values;
    protected char separator = (char)61;

    public BasicValueModel() {
        this.comments = new Comment();
        this.values = new ArrayList<String>();
    }

    public BasicValueModel(String ... value) {
        this();
        for (String v : value) {
            this.values.add(v);
        }
    }

    public BasicValueModel(char sep, String ... value) {
        this();
        this.separator = sep;
        for (String v : value) {
            this.values.add(v);
        }
    }

    public BasicValueModel(Comment comments, List<String> values) {
        this.comments = comments;
        this.values = values;
    }

    public BasicValueModel(Comment comments, String[] values) {
        this.comments = comments;
        this.values = new ArrayList<String>();
        for (String v : values) {
            this.values.add(v);
        }
    }

    public BasicValueModel(Comment comments, char sep, String[] values) {
        this.separator = sep;
        this.comments = comments;
        this.values = new ArrayList<String>();
        for (String v : values) {
            this.values.add(v);
        }
    }

    public BasicValueModel(Comment comments, char sep, List<String> values) {
        this.separator = sep;
        this.comments = comments;
        this.values = new ArrayList<String>();
        values.forEach(item -> this.values.add((String)item));
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + this.separator;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicValueModel other = (BasicValueModel)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.separator != other.separator) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    public Comment getComments() {
        return this.comments;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addValues(List<String> values) {
        this.values.addAll(values);
    }

    public void addComment(String line) {
        this.comments.addLine(line);
    }

    public void addComments(List<String> comments) {
        this.comments.addAll(comments);
    }

    public void clearComments() {
        this.comments.clear();
    }

    public void clearValues() {
        this.values.clear();
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (String value : this.values) {
            b.append(value);
        }
        return b.toString();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public boolean containsUnicodeEscape() {
        for (String val : this.values) {
            if (!val.contains("\\u")) continue;
            return true;
        }
        return this.comments != null && this.comments.containsUnicodeEscape();
    }
}

