/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.io;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.impl.PropertiesImpl;
import asia.redact.bracket.properties.io.AsciiToNativeFilterReader;
import asia.redact.bracket.properties.io.BracketPropertiesSAXHandler;
import asia.redact.bracket.properties.json.Json;
import asia.redact.bracket.properties.json.JsonObject;
import asia.redact.bracket.properties.json.JsonValue;
import asia.redact.bracket.properties.line.LineScanner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class InputAdapter {
    public final Properties props;
    public File currentFile;
    public Charset currentCharset;

    public InputAdapter() {
        this.props = new PropertiesImpl(false).init();
    }

    public InputAdapter(boolean concurrent) {
        this.props = new PropertiesImpl(concurrent).init();
    }

    public InputAdapter(Properties props) {
        this.props = props;
    }

    public void readFile(File path, Charset charset) {
        block113: {
            this.currentFile = path;
            this.currentCharset = charset;
            if (charset.displayName().equals("ISO-8859-1") || charset.displayName().equals("US-ASCII")) {
                try (FileInputStream in = new FileInputStream(path);
                     InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
                     AsciiToNativeFilterReader filter = new AsciiToNativeFilterReader(reader);
                     BufferedReader breader = new BufferedReader(filter);
                     LineScanner scanner = new LineScanner(breader);){
                    Properties p = new PropertiesParser(scanner).parse().getProperties();
                    this.props.merge(p);
                    break block113;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try (FileInputStream in = new FileInputStream(path);
                 InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
                 BufferedReader breader = new BufferedReader(reader);
                 LineScanner scanner = new LineScanner(breader);){
                Properties p = new PropertiesParser(scanner).parse().getProperties();
                this.props.merge(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void readMap(Map<String, ?> map) {
        map.keySet().forEach(key -> this.props.put((String)key, String.valueOf(map.get(key))));
    }

    public void readLegacyProperties(java.util.Properties legacy) {
        Set<Object> set = legacy.keySet();
        for (Object key : set) {
            String val = legacy.getProperty(String.valueOf(key));
            this.props.put(String.valueOf(key), val);
        }
    }

    public void readURL(URL url) {
        try (InputStream in = url.openStream();
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
             AsciiToNativeFilterReader filter = new AsciiToNativeFilterReader(reader);
             BufferedReader breader = new BufferedReader(filter);
             LineScanner scanner = new LineScanner(breader);){
            Properties p = new PropertiesParser(scanner).parse().getProperties();
            this.props.merge(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void read(Reader reader) {
        try (AsciiToNativeFilterReader filter = new AsciiToNativeFilterReader(reader);
             LineScanner scanner = new LineScanner(filter);){
            Properties p = new PropertiesParser(scanner).parse().getProperties();
            this.props.merge(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readXML(Reader reader) {
        this.readXML(reader, false);
    }

    public void readXML(Reader reader, boolean validate) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(validate);
        try (AsciiToNativeFilterReader a_reader = new AsciiToNativeFilterReader(reader);){
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(a_reader);
            parser.parse(source, (DefaultHandler)new BracketPropertiesSAXHandler(this.props));
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException("Parsing properties failed: " + x.getMessage());
        }
    }

    public void readJSON(Reader in) {
        try (AsciiToNativeFilterReader a_reader = new AsciiToNativeFilterReader(in);){
            JsonValue root = Json.parse(a_reader);
            JsonObject obj = root.asObject();
            obj.forEach(item -> this.props.put(item.getName(), item.getValue().asString()));
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing properties failed: " + e.getMessage());
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public Charset getCurrentCharset() {
        return this.currentCharset;
    }
}

