/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.io;

import asia.redact.bracket.properties.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BracketPropertiesSAXHandler
extends DefaultHandler {
    protected Properties props;
    protected String key;
    protected String value;

    public BracketPropertiesSAXHandler(Properties props) {
        this.props = props;
    }

    @Override
    public InputSource resolveEntity(String systemId, String publicId) throws SAXException, IOException {
        InputStream in = this.getClass().getResourceAsStream("/xml/props.dtd");
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return new InputSource(reader);
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.value = new String(buffer, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int count = attributes.getLength();
        if (qName.equals("entry") && count > 0) {
            this.key = attributes.getValue("key");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.key != null) {
            this.props.put(this.key, this.value);
        }
    }
}

