/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.io;

import asia.redact.bracket.properties.io.NativeToAsciiFilter;
import asia.redact.bracket.properties.io.OutputFormat;
import asia.redact.bracket.properties.values.Comment;
import java.util.List;

public class AsciiOutputFormat
implements OutputFormat {
    @Override
    public String formatContentType() {
        return "";
    }

    @Override
    public String formatHeader() {
        return "";
    }

    @Override
    public String format(String key, char separator, List<String> values, Comment comments) {
        if (key == null) {
            throw new RuntimeException("Key cannot be null in a format");
        }
        StringBuffer buf = new StringBuffer();
        if (comments != null && comments.size() > 0) {
            buf.append(new NativeToAsciiFilter().write(comments.comments).getResult());
            buf.append("\n");
        }
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == ':' || ch == '=') {
                keyBuilder.append('\\');
            }
            keyBuilder.append(ch);
        }
        buf.append(keyBuilder.toString());
        buf.append(separator);
        if (values != null && values.size() > 0) {
            int count = values.size();
            int i = 0;
            for (String s : values) {
                buf.append(new NativeToAsciiFilter().write(s).getResult());
                if (i < count - 1) {
                    buf.append('\\');
                }
                buf.append(lineSeparator);
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public String formatFooter() {
        return "";
    }
}

