/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalePathBuilder {
    final Locale locale;
    final String path;
    final String ext;

    public LocalePathBuilder(String path, Locale locale, String fileExtension) {
        this.locale = locale;
        this.path = path;
        this.ext = fileExtension;
    }

    public List<String> getSearchStrings() {
        StringBuilder b;
        ArrayList<String> list = new ArrayList<String>();
        if (this.hasLanguageCountryVariant()) {
            b = new StringBuilder();
            b.append(this.path).append("_").append(this.locale.getLanguage()).append("_").append(this.locale.getCountry()).append("_").append(this.locale.getVariant()).append(this.ext);
            list.add(b.toString());
        }
        if (this.hasLanguageCountry()) {
            b = new StringBuilder();
            b.append(this.path).append("_").append(this.locale.getLanguage()).append("_").append(this.locale.getCountry()).append(this.ext);
            list.add(b.toString());
        }
        if (this.hasLanguage()) {
            b = new StringBuilder();
            b.append(this.path).append("_").append(this.locale.getLanguage()).append(this.ext);
            list.add(b.toString());
        }
        b = new StringBuilder();
        b.append(this.path).append(this.ext);
        list.add(b.toString());
        return list;
    }

    private boolean hasLanguageCountryVariant() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        if (this.locale.getCountry().equals("")) {
            return false;
        }
        return !this.locale.getVariant().equals("");
    }

    private boolean hasLanguageCountry() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        return !this.locale.getCountry().equals("");
    }

    private boolean hasLanguage() {
        return !this.locale.getLanguage().equals("");
    }
}

