/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.adapter;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.adapter.Quote;

public class QuoteAdapter
implements Quote {
    final Properties props;

    public QuoteAdapter(Properties props) {
        this.props = props;
    }

    @Override
    public void dq(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        buf.append(this.props.get(key));
        buf.append("\"");
        this.props.put(key, buf.toString());
    }

    @Override
    public void sq(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        buf.append(this.props.get(key));
        buf.append("'");
        this.props.put(key, buf.toString());
    }

    @Override
    public void curly(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append('\u201c');
        buf.append(this.props.get(key));
        buf.append("\u201d");
        this.props.put(key, buf.toString());
    }

    @Override
    public void scurly(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append('\u2018');
        buf.append(this.props.get(key));
        buf.append("\u2019");
        this.props.put(key, buf.toString());
    }

    @Override
    public void dequote(String key) {
        if (!this.props.containsKey(key)) {
            return;
        }
        String val = this.props.get("key");
        boolean startsWith = false;
        boolean endsWith = false;
        if (this.isQuote(val.charAt(0))) {
            startsWith = true;
        }
        if (this.isQuote(val.charAt(val.length() - 1))) {
            endsWith = true;
        }
        StringBuffer buf = new StringBuffer(val);
        if (startsWith) {
            buf.deleteCharAt(0);
        }
        if (endsWith) {
            buf.deleteCharAt(buf.length() - 1);
        }
        this.props.put(key, buf.toString());
    }

    @Override
    public void quoteAll(char start, char end) {
        this.props.forEach((k, v) -> {
            StringBuffer buf = new StringBuffer();
            buf.append(start);
            buf.append(v);
            buf.append(end);
            this.props.put((String)k, buf.toString());
        });
    }

    @Override
    public void dequoteAll() {
        this.props.forEach((k, v) -> {
            StringBuffer buf = new StringBuffer();
            buf.append(v);
            buf.deleteCharAt(buf.length() - 1);
            buf.deleteCharAt(0);
            this.props.put((String)k, buf.toString());
        });
    }

    private boolean isQuote(char ch) {
        switch (ch) {
            case '\'': {
                return true;
            }
            case '\"': {
                return true;
            }
            case '\u201c': {
                return true;
            }
            case '\u201d': {
                return true;
            }
            case '\u2018': {
                return true;
            }
            case '\u2019': {
                return true;
            }
        }
        return false;
    }
}

