/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.adapter;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.adapter.I18N;
import java.util.Locale;

public class I18NAdapter
implements I18N {
    Properties props;
    Locale locale;

    public I18NAdapter(Properties props) {
        this.props = props;
        this.locale = Locale.getDefault();
    }

    public I18NAdapter(Properties props, Locale locale) {
        this.props = props;
        this.locale = locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String prefix() {
        if (this.hasLanguageCountryVariant()) {
            StringBuilder b = new StringBuilder();
            b.append(this.locale.getLanguage()).append(".").append(this.locale.getCountry()).append(".").append(this.locale.getVariant()).append(".");
            return b.toString();
        }
        if (this.hasLanguageCountry()) {
            StringBuilder b = new StringBuilder();
            b.append(this.locale.getLanguage()).append(".").append(this.locale.getCountry()).append(".");
            return b.toString();
        }
        if (this.hasLanguage()) {
            return this.locale.getLanguage() + ".";
        }
        return Locale.getDefault().getCountry() + ".";
    }

    private boolean hasLanguageCountryVariant() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        if (this.locale.getCountry().equals("")) {
            return false;
        }
        return !this.locale.getVariant().equals("");
    }

    private boolean hasLanguageCountry() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        return !this.locale.getCountry().equals("");
    }

    private boolean hasLanguage() {
        return !this.locale.getLanguage().equals("");
    }

    @Override
    public String get(String key) {
        return this.props.get(this.prefix() + key);
    }

    @Override
    public String get(String key, String defaultVal) {
        return this.props.get(this.prefix() + key, defaultVal);
    }

    @Override
    public void put(String key, String ... values) {
        this.props.put(this.prefix() + key, values);
    }

    @Override
    public boolean containsKey(String key) {
        return this.props.containsKey(this.prefix() + key);
    }
}

