/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import asia.redact.bracket.util.CustomKeyWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessorMethodGetter {
    final Class<?> clazz;
    final Object instance;
    private final Pattern getterPattern = Pattern.compile("(get|is)[A-Z][a-zA-Z0-9]+");

    public AccessorMethodGetter(Class<?> clazz, Object instance) {
        this.clazz = clazz;
        this.instance = instance;
    }

    public List<Method> listGetters() {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : this.clazz.getMethods()) {
            Class<?>[] params;
            Matcher matcher;
            if (m.getName().equals("getClass") || !(matcher = this.getterPattern.matcher(m.getName())).matches() || (params = m.getParameterTypes()) == null || params.length != 0) continue;
            list.add(m);
        }
        return list;
    }

    public CustomKeyWrapper invoke(Method m) {
        m.setAccessible(true);
        try {
            Object obj = m.invoke(this.instance, new Object[0]);
            CustomKeyWrapper wrapper = new CustomKeyWrapper(this.keyify(m.getName()), obj);
            if (obj instanceof List) {
                // empty if block
            }
            return wrapper;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private String keyify(String getter) {
        StringBuffer buf = new StringBuffer();
        if (getter.startsWith("get")) {
            buf.append(getter.substring(3).toLowerCase());
        } else if (getter.startsWith("is")) {
            buf.append(getter.substring(2).toLowerCase());
        }
        return buf.toString();
    }
}

