/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.line;

import asia.redact.bracket.properties.line.Line;
import asia.redact.bracket.properties.line.LineEnding;
import java.io.IOException;
import java.io.Reader;

public class LineScanner
extends Reader {
    private final Reader in;
    private char[] buf;
    private int pos;
    private int end;
    private int mark = -1;
    private int markLimit = -1;
    private long totalRead = 0L;
    private int delimiterLength;
    private LineEnding delimiter;

    public LineScanner(Reader in) {
        super((Object)in);
        this.in = in;
        this.buf = new char[8192];
    }

    public LineScanner(Reader in, int size) {
        super((Object)in);
        if (size <= 0) {
            throw new IllegalArgumentException("buf must be given a size");
        }
        this.in = in;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                this.in.close();
                this.buf = null;
            }
        }
    }

    private int fillBuf() throws IOException {
        if (this.mark == -1 || this.pos - this.mark >= this.markLimit) {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.mark = -1;
                this.pos = 0;
                this.end = result;
            }
            return result;
        }
        if (this.mark == 0 && this.markLimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.markLimit) {
                newLength = this.markLimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.mark > 0) {
            System.arraycopy(this.buf, this.mark, this.buf, 0, this.buf.length - this.mark);
            this.pos -= this.mark;
            this.end -= this.mark;
            this.mark = 0;
        }
        int count = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (count != -1) {
            this.end += count;
        }
        return count;
    }

    private boolean isClosed() {
        return this.buf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int markLimit) throws IOException {
        if (markLimit < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Closed reader");
            }
            this.markLimit = markLimit;
            this.mark = this.pos;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Buffer closed");
            }
            if (this.pos < this.end || this.fillBuf() != -1) {
                ++this.totalRead;
                return this.buf[this.pos++];
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int count;
            if (this.isClosed()) {
                throw new IOException("");
            }
            if (offset < 0 || offset > buffer.length - length || length < 0) {
                throw new IndexOutOfBoundsException();
            }
            int outstanding = length;
            while (outstanding > 0) {
                int count2;
                int available = this.end - this.pos;
                if (available > 0) {
                    count2 = available >= outstanding ? outstanding : available;
                    System.arraycopy(this.buf, this.pos, buffer, offset, count2);
                    this.pos += count2;
                    offset += count2;
                    outstanding -= count2;
                }
                if (outstanding == 0 || outstanding < length && !this.in.ready()) break;
                if ((this.mark == -1 || this.pos - this.mark >= this.markLimit) && outstanding >= this.buf.length) {
                    count2 = this.in.read(buffer, offset, outstanding);
                    if (count2 <= 0) break;
                    offset += count2;
                    outstanding -= count2;
                    this.mark = -1;
                    break;
                }
                if (this.fillBuf() != -1) continue;
                break;
            }
            int retVal = (count = length - outstanding) > 0 || count == length ? count : -1;
            this.totalRead += (long)retVal;
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line line() {
        Object object = this.lock;
        synchronized (object) {
            try {
                String text = this.readLine();
                if (text != null) {
                    long startIndex = this.totalRead - (long)text.length() - (long)this.delimiterLength;
                    return new Line(text, startIndex, this.delimiter);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Buffer closed");
            }
            if (this.pos == this.end && this.fillBuf() == -1) {
                return null;
            }
            for (int charPos = this.pos; charPos < this.end; ++charPos) {
                char ch = this.buf[charPos];
                if (ch > '\r') continue;
                if (ch == '\n') {
                    String res = new String(this.buf, this.pos, charPos - this.pos);
                    this.pos = charPos + 1;
                    this.totalRead += (long)(res.length() + 1);
                    this.delimiterLength = 1;
                    this.delimiter = LineEnding.LF;
                    return res;
                }
                if (ch != '\r') continue;
                String res = new String(this.buf, this.pos, charPos - this.pos);
                this.pos = charPos + 1;
                this.totalRead += (long)(res.length() + 1);
                this.delimiterLength = 1;
                this.delimiter = LineEnding.CR;
                if ((this.pos < this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
                    ++this.totalRead;
                    this.delimiterLength = 2;
                    this.delimiter = LineEnding.CRLF;
                    ++this.pos;
                }
                return res;
            }
            int eol = 0;
            StringBuilder result = new StringBuilder(80);
            result.append(this.buf, this.pos, this.end - this.pos);
            while (true) {
                this.pos = this.end;
                if (eol == 10) {
                    this.totalRead += (long)(result.length() + 1);
                    this.delimiterLength = 1;
                    this.delimiter = LineEnding.LF;
                    return result.toString();
                }
                if (this.fillBuf() == -1) {
                    String tmp;
                    String string = tmp = result.length() > 0 || eol != 0 ? result.toString() : null;
                    if (tmp != null) {
                        this.totalRead += (long)result.length();
                    }
                    this.delimiterLength = 1;
                    this.delimiter = eol == 13 ? LineEnding.CR : LineEnding.LF;
                    return tmp;
                }
                for (int charPos = this.pos; charPos < this.end; ++charPos) {
                    int c = this.buf[charPos];
                    if (eol == 0) {
                        if (c != 10 && c != 13) continue;
                        eol = c;
                        continue;
                    }
                    if (eol == 13 && c == 10) {
                        if (charPos > this.pos) {
                            result.append(this.buf, this.pos, charPos - this.pos - 1);
                        }
                        this.pos = charPos + 1;
                        this.totalRead += (long)(result.length() + 2);
                        this.delimiterLength = 2;
                        this.delimiter = LineEnding.CRLF;
                        return result.toString();
                    }
                    if (charPos > this.pos) {
                        result.append(this.buf, this.pos, charPos - this.pos - 1);
                    }
                    this.pos = charPos;
                    this.totalRead += (long)(result.length() + 1);
                    this.delimiterLength = 1;
                    this.delimiter = eol == 13 ? LineEnding.CR : LineEnding.LF;
                    return result.toString();
                }
                if (eol == 0) {
                    result.append(this.buf, this.pos, this.end - this.pos);
                    continue;
                }
                result.append(this.buf, this.pos, this.end - this.pos - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Buffer closed");
            }
            return this.end - this.pos > 0 || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Buffer closed");
            }
            if (this.mark == -1) {
                throw new IOException("mark == -1");
            }
            this.pos = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long amount) throws IOException {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("");
            }
            if (amount < 1L) {
                return 0L;
            }
            if ((long)(this.end - this.pos) >= amount) {
                this.pos = (int)((long)this.pos + amount);
                return amount;
            }
            this.pos = this.end;
            for (long read = (long)(this.end - this.pos); read < amount; read += (long)(this.end - this.pos)) {
                if (this.fillBuf() == -1) {
                    return read;
                }
                if ((long)(this.end - this.pos) >= amount - read) {
                    this.pos = (int)((long)this.pos + (amount - read));
                    return amount;
                }
                this.pos = this.end;
            }
            this.totalRead += amount;
            return amount;
        }
    }

    public long getTotalRead() {
        return this.totalRead;
    }

    public LineEnding getDelimiter() {
        return this.delimiter;
    }
}

