/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.NodeImpl;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;

class TreeBuilder {
    final Node root;
    final Properties props;

    TreeBuilder(Properties props) {
        this.root = new NodeImpl("");
        this.props = props;
    }

    TreeBuilder(Properties props, String rootNodeName) {
        this.root = rootNodeName != null && !rootNodeName.equals("") ? new NodeImpl(rootNodeName) : new NodeImpl("");
        this.props = props;
    }

    void createNode(String key, ValueModel value, String regex) {
        String[] parts = key.split(regex);
        this.descend(this.root, key, parts, value, 0);
    }

    void descend(Node node, String path, String[] parts, ValueModel value, int depth) {
        if (parts.length == depth) {
            return;
        }
        String key = parts[depth];
        Node target = null;
        for (Node n : node.getChildren()) {
            if (!n.getName().equals(key)) continue;
            target = n;
            break;
        }
        if (target == null) {
            target = new NodeImpl(key);
            node.addChild(target);
        }
        if (depth == parts.length - 1) {
            target.value = value;
        }
        this.descend(target, path, parts, value, ++depth);
    }

    Node tree() {
        return this.root;
    }
}

