/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.OutputFormat;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Set;

public class RandomAccessFileOutputAdapter {
    Properties props;

    public RandomAccessFileOutputAdapter(Properties props) {
        this.props = props;
    }

    public void writeTo(RandomAccessFile file, OutputFormat format) throws IOException {
        Set<Map.Entry<String, ValueModel>> set = this.props.getPropertyMap().entrySet();
        file.writeChars(format.formatContentType());
        file.writeChars(format.formatHeader());
        for (Map.Entry<String, ValueModel> e : set) {
            String key = e.getKey();
            ValueModel model = e.getValue();
            file.writeBytes(format.format(key, model.getSeparator(), model.getValues(), model.getComments()));
        }
        file.writeBytes(format.formatFooter());
    }
}

