/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.AbstractPropertiesBase;
import asia.redact.bracket.properties.BasicValueModel;
import asia.redact.bracket.properties.Comment;
import asia.redact.bracket.properties.GroupParams;
import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.TreeBuilder;
import asia.redact.bracket.properties.TreeSynchronizer;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.util.AccessorMethodSetter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesImpl
extends AbstractPropertiesBase
implements Properties {
    private static final long serialVersionUID = 1L;
    protected Pattern dotIntegerPattern = Pattern.compile("\\.(\\d+)");
    protected Pattern dotIdentifierPattern = Pattern.compile("\\.([a-zA-Z]+[a-zA-Z0-9]+)");
    protected Pattern dotKeyValuePattern = Pattern.compile("\\.\\d+\\.[kv]");
    protected static final String REF_TOKEN = "_$";

    public PropertiesImpl() {
        this.initMap();
    }

    protected void initMap() {
        this.map = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(java.util.Properties legacy) {
        this();
        this.lock.lock();
        try {
            Set<Object> set = legacy.keySet();
            for (Object key : set) {
                String val = legacy.getProperty(String.valueOf(key));
                this.put(String.valueOf(key), val);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public PropertiesImpl(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.put(String.valueOf(key), String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(URL url) {
        this();
        InputStream in = null;
        this.lock.lock();
        try {
            in = url.openStream();
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(InputStream in) {
        this();
        this.lock.lock();
        try {
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(InputStream in, Charset charset) {
        this();
        this.lock.lock();
        try {
            PropertiesLexer lexer = new PropertiesLexer(in, charset);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(Reader in) {
        this();
        this.lock.lock();
        try {
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        this.lock.lock();
        try {
            ValueModel val = (ValueModel)this.map.get(key);
            if (val == null) {
                throw new RuntimeException("Missing value " + key + ". Normally you would test for the existence of keys by using containsKey(key) prior to using get() if there is doubt");
            }
            String string = val.getValue();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getKeyRef(String key) {
        String v = this.get(key);
        if (v.startsWith(REF_TOKEN)) {
            return this.getKeyRef(v.substring(2));
        }
        return v;
    }

    public void putKeyRef(String newRefKey, String existingKey) {
        if (!this.containsKey(existingKey)) {
            throw new RuntimeException("Should be existing key: " + existingKey);
        }
        this.put(newRefKey, REF_TOKEN + existingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String ... values) {
        this.lock.lock();
        try {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new BasicValueModel(values));
            } else {
                ValueModel val = (ValueModel)this.map.get(key);
                val.getValues().clear();
                for (String s : values) {
                    val.getValues().add(s);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, List<String> values) {
        this.lock.lock();
        try {
            this.putList(key, ' ', values);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Comment comment, String ... values) {
        this.lock.lock();
        try {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new BasicValueModel(comment, values));
            } else {
                ValueModel val = (ValueModel)this.map.get(key);
                if (val instanceof BasicValueModel) {
                    ((BasicValueModel)val).addComment(comment.comment);
                }
                val.getValues().clear();
                for (String s : values) {
                    val.getValues().add(s);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, char separator, String ... values) {
        this.lock.lock();
        try {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new BasicValueModel(separator, values));
            } else {
                ValueModel val = (ValueModel)this.map.get(key);
                if (val instanceof BasicValueModel) {
                    ((BasicValueModel)val).setSeparator(separator);
                }
                val.getValues().clear();
                for (String s : values) {
                    val.getValues().add(s);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, char separator, Comment comment, String ... values) {
        this.lock.lock();
        try {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new BasicValueModel(comment, separator, values));
            } else {
                ValueModel val = (ValueModel)this.map.get(key);
                if (val instanceof BasicValueModel) {
                    ((BasicValueModel)val).addComment(comment.comment);
                    ((BasicValueModel)val).setSeparator(separator);
                }
                val.getValues().clear();
                for (String s : values) {
                    val.getValues().add(s);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(String key, int val) {
        this.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, BigInteger bi) {
        this.put(key, String.valueOf(bi));
    }

    @Override
    public void put(String key, BigDecimal bd) {
        this.put(key, String.valueOf(bd));
    }

    @Override
    public void put(String key, float val) {
        this.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, double val) {
        this.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, boolean val) {
        this.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, char val) {
        this.put(key, String.valueOf(val));
    }

    @Override
    public Map<String, ValueModel> getPropertyMap() {
        return this.map;
    }

    @Override
    public synchronized Map<String, String> getFlattenedMap() {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        for (String key : this.map.keySet()) {
            String value = ((ValueModel)this.map.get(key)).getValue();
            out.put(key, value);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComments(String key) {
        this.lock.lock();
        try {
            if (!this.containsKey(key)) {
                List<String> list = null;
                return list;
            }
            List<String> list = this.getPropertyMap().get(key).getComments();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getSeparator(String key) {
        this.lock.lock();
        try {
            if (!this.containsKey(key)) {
                char c = '\u0000';
                return c;
            }
            char c = this.getPropertyMap().get(key).getSeparator();
            return c;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeyGroup(String keyBase) {
        this.lock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : this.map.keySet()) {
                if (s.indexOf(keyBase) != 0) continue;
                list.add(s);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.lock();
        try {
            int prime = 31;
            int result = 1;
            int n = result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.lock.lock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            if (this.getClass() != obj.getClass()) {
                boolean bl = false;
                return bl;
            }
            PropertiesImpl other = (PropertiesImpl)obj;
            if (this.map == null) {
                if (other.map != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.map.equals(other.map)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Properties merge(Properties props) {
        this.merge(props, false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties merge(Properties props, boolean mergeComments) {
        this.lock.lock();
        try {
            Set<String> set = props.getPropertyMap().keySet();
            for (String key : set) {
                if (mergeComments) {
                    List<String> comments = this.getComments(key);
                    List<String> newComments = props.getComments(key);
                    if (comments == null) {
                        comments = new ArrayList<String>();
                    }
                    if (newComments != null) {
                        for (String s : newComments) {
                            comments.add(s);
                        }
                    }
                    BasicValueModel model = new BasicValueModel(comments, props.getPropertyMap().get(key).getValues());
                    this.getPropertyMap().put(key, model);
                    continue;
                }
                this.getPropertyMap().put(key, props.getPropertyMap().get(key));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public Node getTree() {
        return this.getTree(new GroupParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getTree(GroupParams params) {
        this.lock.lock();
        try {
            TreeBuilder builder = new TreeBuilder(this, params.rootNodeName);
            Set keys = this.map.keySet();
            for (String key : keys) {
                if (!key.startsWith(params.getPartialKey())) continue;
                ValueModel value = (ValueModel)this.map.get(key);
                builder.createNode(key, value, params.getSeparator());
            }
            Node node = builder.tree();
            return node;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Properties getGroup(GroupParams params) {
        PropertiesImpl impl = new PropertiesImpl();
        for (String key : this.getPropertyMap().keySet()) {
            if (!key.startsWith(params.getPartialKey())) continue;
            ValueModel value = (ValueModel)this.map.get(key);
            impl.getPropertyMap().put(key, value);
        }
        return impl;
    }

    public List<String> getMatchingKeys(String partial) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.getPropertyMap().keySet()) {
            if (!key.startsWith(partial)) continue;
            ValueModel value = (ValueModel)this.map.get(key);
            list.add(value.getValue());
        }
        return list;
    }

    @Override
    public boolean hasKeyLike(String partial) {
        for (String key : this.getPropertyMap().keySet()) {
            if (!key.startsWith(partial)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int intValue(String key) {
        return Integer.parseInt(this.get(key));
    }

    @Override
    public boolean booleanValue(String key) {
        return Boolean.parseBoolean(this.get(key));
    }

    @Override
    public long longValue(String key) {
        return Long.parseLong(this.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date dateValue(String key) {
        this.lock.lock();
        try {
            String val = this.get(key);
            if (val.trim().length() != 13) {
                throw new RuntimeException("Value does not look like a long that could be used as a date");
            }
            Date date = new Date(this.longValue(key));
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date dateValue(String key, String format) throws ParseException {
        this.lock.lock();
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            Date date = f.parse(this.get(key));
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue(String key) {
        this.lock.lock();
        try {
            String val = this.get(key);
            boolean bl = val != null && !val.equals("");
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Node rootNode) {
        this.lock.lock();
        try {
            new TreeSynchronizer(this, rootNode).synch();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void mergeIntoSystemProperties() {
        Map<String, ValueModel> map = this.getPropertyMap();
        for (String key : map.keySet()) {
            System.setProperty(key, map.get(key).getValue());
        }
    }

    @Override
    public List<String> getMapKeys(String keyBase) {
        ArrayList<String> list = new ArrayList<String>();
        Set keys = this.map.keySet();
        for (String k : keys) {
            String remainder;
            Matcher matcher;
            if (!k.startsWith(keyBase) || !(matcher = this.dotKeyValuePattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
            list.add(k);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getListKeys(String keyBase) {
        ArrayList<String> list = new ArrayList<String>();
        Set keys = this.map.keySet();
        for (String k : keys) {
            String remainder;
            Matcher matcher;
            if (!k.startsWith(keyBase) || !(matcher = this.dotIntegerPattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
            list.add(k);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getList(String keyBase) {
        ArrayList<String> list = new ArrayList<String>();
        TreeMap<Integer, String> numberedMap = new TreeMap<Integer, String>();
        Set keys = this.map.keySet();
        for (String k : keys) {
            String remainder;
            Matcher matcher;
            if (!k.startsWith(keyBase) || !(matcher = this.dotIntegerPattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
            Integer keyInt = Integer.parseInt(matcher.group(1));
            numberedMap.put(keyInt, ((ValueModel)this.map.get(k)).getValue());
        }
        if (numberedMap.size() == 0) {
            return list;
        }
        Set numberKeySet = numberedMap.keySet();
        for (Integer i : numberKeySet) {
            list.add((String)numberedMap.get(i));
        }
        return list;
    }

    @Override
    public List<String> listValue(String key) {
        String[] items;
        ArrayList<String> list = new ArrayList<String>();
        String val = this.get(key);
        for (String s : items = val.split(" ")) {
            list.add(s);
        }
        return list;
    }

    @Override
    public List<String> listValue(String key, String delimiter) {
        String[] items;
        ArrayList<String> list = new ArrayList<String>();
        String val = this.get(key);
        for (String s : items = val.split(delimiter)) {
            list.add(s);
        }
        return list;
    }

    public void putList(String key, char ch, List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String val : list) {
            buf.append(val);
            buf.append(ch);
        }
        buf.deleteCharAt(buf.length() - 1);
        this.put(key, buf.toString());
    }

    @Override
    public BitSet bitsetValue(String key) {
        String value = this.get(key).trim();
        BitSet set = new BitSet(value.length());
        for (int i = 0; i < value.length(); ++i) {
            set.set(i, value.charAt(i) == '1');
        }
        return set;
    }

    @Override
    public BigInteger bigValue(String key) {
        return new BigInteger(this.get(key).trim());
    }

    @Override
    public BigDecimal bigDecimalValue(String key) {
        return new BigDecimal(this.get(key).trim());
    }

    @Override
    public Object beanValue(Class<?> clazz, String keyBase) {
        try {
            Object obj = clazz.newInstance();
            Set keys = this.map.keySet();
            for (String k : keys) {
                String remainder;
                Matcher matcher;
                if (!k.startsWith(keyBase) || !(matcher = this.dotIdentifierPattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
                String identifier = matcher.group(1);
                String value = this.get(k);
                AccessorMethodSetter setter = new AccessorMethodSetter(clazz, obj, identifier, value);
                setter.set();
                if (!setter.success()) continue;
            }
            return obj;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void putList(List<String> list, String rootKey) {
        int count = 0;
        for (String val : list) {
            StringBuffer buf = new StringBuffer(rootKey);
            buf.append(".");
            buf.append(count);
            this.put(buf.toString(), val);
            ++count;
        }
    }

    @Override
    public void putList(List<String> list, Comment comment, String rootKey) {
        int count = 0;
        for (String val : list) {
            StringBuffer buf = new StringBuffer(rootKey);
            buf.append(".");
            buf.append(count);
            if (count == 0) {
                this.put(buf.toString(), comment, val);
            } else {
                this.put(buf.toString(), val);
            }
            ++count;
        }
    }

    public void putList(List<String> list, char sep, Comment comment, String rootKey) {
        int count = 0;
        for (String val : list) {
            StringBuffer buf = new StringBuffer(rootKey);
            buf.append(".");
            buf.append(count);
            if (count == 0) {
                this.put(buf.toString(), sep, comment, val);
            } else {
                this.put(buf.toString(), sep, val);
            }
            ++count;
        }
    }

    @Override
    public java.util.Properties convertToLegacyProperties() {
        java.util.Properties legacy = new java.util.Properties();
        for (String key : this.getPropertyMap().keySet()) {
            String value = this.get(key);
            legacy.put(key, value);
        }
        return legacy;
    }
}

