/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Comment;
import asia.redact.bracket.properties.ContentType;
import asia.redact.bracket.properties.GroupParams;
import asia.redact.bracket.properties.LocaleStringBuilder;
import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.ParseXML;
import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesParser2;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.SortedPropertiesImpl;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.properties.alt.DotPropertiesParser;
import asia.redact.bracket.properties.line.LineScanner;
import asia.redact.bracket.properties.mgmt.Attributes;
import asia.redact.bracket.properties.mgmt.LoadList;
import asia.redact.bracket.properties.mgmt.PropertiesReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface Properties
extends Serializable {
    public Map<String, ValueModel> getPropertyMap();

    public Map<String, String> getFlattenedMap();

    public String get(String var1);

    public int intValue(String var1);

    public boolean booleanValue(String var1);

    public long longValue(String var1);

    public Date dateValue(String var1);

    public Date dateValue(String var1, String var2) throws ParseException;

    public List<String> listValue(String var1);

    public List<String> listValue(String var1, String var2);

    public void put(String var1, List<String> var2);

    public BitSet bitsetValue(String var1);

    public BigInteger bigValue(String var1);

    public BigDecimal bigDecimalValue(String var1);

    public Object beanValue(Class<?> var1, String var2);

    public Node getTree();

    public Node getTree(GroupParams var1);

    public List<String> getComments(String var1);

    public char getSeparator(String var1);

    public void put(String var1, String ... var2);

    public void put(String var1, int var2);

    public void put(String var1, float var2);

    public void put(String var1, double var2);

    public void put(String var1, boolean var2);

    public void put(String var1, char var2);

    public void put(String var1, BigInteger var2);

    public void put(String var1, BigDecimal var2);

    public void put(String var1, Comment var2, String ... var3);

    public void put(String var1, char var2, Comment var3, String ... var4);

    public int size();

    public void clear();

    public boolean containsKey(String var1);

    public boolean hasValue(String var1);

    public Properties merge(Properties var1);

    public Properties merge(Properties var1, boolean var2);

    public void synchronize(Node var1);

    public ContentType getContentType();

    public void setContentType(ContentType var1);

    public void mergeIntoSystemProperties();

    public List<String> getList(String var1);

    public void putList(List<String> var1, String var2);

    public void putList(List<String> var1, Comment var2, String var3);

    public List<String> getListKeys(String var1);

    public List<String> getMapKeys(String var1);

    public boolean hasKeyLike(String var1);

    public java.util.Properties convertToLegacyProperties();

    public static final class Factory {
        public static Mode mode = Mode.BasicToken;

        public static Properties getInstance() {
            return new PropertiesImpl();
        }

        public static synchronized Properties getInstance(URL url) {
            try {
                return Factory.getInstance(url.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException("IOException caught", e);
            }
        }

        public static synchronized Properties getInstance(Reader reader) {
            switch (mode) {
                case BasicToken: {
                    return new PropertiesImpl(reader);
                }
                case Compatibility: {
                    PropertiesLexer lexer = new PropertiesLexer(reader);
                    lexer.lex();
                    List<PropertiesToken> list = lexer.getList();
                    PropertiesImpl props = new PropertiesImpl();
                    props.setContentType(ContentType.getCompatibilityContentType());
                    PropertiesParser p = new PropertiesParser(list, props);
                    p.setTrimValues(true);
                    p.parse();
                    return props;
                }
                case Line: {
                    LineScanner lexer = new LineScanner(reader);
                    PropertiesImpl props = new PropertiesImpl();
                    new PropertiesParser2(lexer, props).parse();
                    return props;
                }
            }
            return new PropertiesImpl(reader);
        }

        public static synchronized Properties getInstance(File file, Charset charset) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader((InputStream)stream, charset);
                Properties properties = Factory.getInstance(reader);
                return properties;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public static synchronized Properties getInstance(InputStream in) {
            switch (mode) {
                case BasicToken: {
                    return new PropertiesImpl(in);
                }
                case Compatibility: {
                    PropertiesLexer lexer = new PropertiesLexer(in);
                    lexer.lex();
                    List<PropertiesToken> list = lexer.getList();
                    PropertiesImpl props = new PropertiesImpl();
                    props.setContentType(ContentType.getCompatibilityContentType());
                    PropertiesParser p = new PropertiesParser(list, props);
                    p.setTrimValues(true);
                    p.parse();
                    return props;
                }
                case Line: {
                    LineScanner lexer = new LineScanner(new InputStreamReader(in));
                    PropertiesImpl props = new PropertiesImpl();
                    new PropertiesParser2(lexer, props).parse();
                    return props;
                }
            }
            return new PropertiesImpl(in);
        }

        public static synchronized Properties getInstance(InputStream in, Charset charset) {
            switch (mode) {
                case BasicToken: {
                    return new PropertiesImpl(in);
                }
                case Compatibility: {
                    PropertiesLexer lexer = new PropertiesLexer(new InputStreamReader(in, charset));
                    lexer.lex();
                    List<PropertiesToken> list = lexer.getList();
                    PropertiesImpl props = new PropertiesImpl();
                    props.setContentType(ContentType.getCompatibilityContentType());
                    PropertiesParser p = new PropertiesParser(list, props);
                    p.setTrimValues(true);
                    p.parse();
                    return props;
                }
                case Line: {
                    LineScanner lexer = new LineScanner(new InputStreamReader(in, charset));
                    PropertiesImpl props = new PropertiesImpl();
                    new PropertiesParser2(lexer, props).parse();
                    return props;
                }
            }
            return new PropertiesImpl(in, charset);
        }

        public static Properties getInstance(java.util.Properties legacy) {
            return new PropertiesImpl(legacy);
        }

        public static Properties getInstance(Map map) {
            return new PropertiesImpl(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Properties getInstance(String baseName, Locale locale) {
            LocaleStringBuilder builder = new LocaleStringBuilder(baseName, locale);
            List<String> list = builder.getSearchStrings();
            PropertiesImpl base = new PropertiesImpl();
            for (String s : list) {
                InputStream in = null;
                try {
                    in = Thread.currentThread().getClass().getResourceAsStream(s);
                    if (in == null) continue;
                    base.merge(Factory.getInstance(in));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return base;
        }

        public static synchronized Properties getInstanceFromXML(File file, Charset charset) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
                BufferedReader breader = new BufferedReader(reader);
                ParseXML parser = new ParseXML();
                parser.parse(breader);
                return parser.getProps();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static synchronized Properties getInstanceFromXML(File file) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                Charset charset = null;
                charset = mode == Mode.Compatibility ? Charset.forName("ISO-8859-1") : Charset.forName("UTF-8");
                InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
                BufferedReader breader = new BufferedReader(reader);
                ParseXML parser = new ParseXML();
                parser.parse(breader);
                return parser.getProps();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static synchronized Properties sortedInstance(Properties props) {
            SortedPropertiesImpl impl = new SortedPropertiesImpl();
            return impl.merge(props);
        }

        public static synchronized Properties sortedInstance(Properties props, Comparator<String> comp) {
            SortedPropertiesImpl impl = new SortedPropertiesImpl(comp);
            return impl.merge(props);
        }

        public static synchronized Properties getDotInstance(Reader reader) {
            LineScanner lexer = new LineScanner(reader);
            DotPropertiesParser p = new DotPropertiesParser(lexer);
            p.parse();
            Properties props = p.getProperties();
            props.setContentType(ContentType.getDotPropertiesContentType());
            return props;
        }

        public static synchronized Properties getDotInstance(InputStream in) {
            LineScanner lexer = new LineScanner(new InputStreamReader(in));
            DotPropertiesParser p = new DotPropertiesParser(lexer);
            p.parse();
            Properties props = p.getProperties();
            props.setContentType(ContentType.getDotPropertiesContentType());
            return props;
        }

        public static synchronized Properties loadReferences(List<PropertiesReference> refs) {
            Attributes attribs = new Attributes();
            attribs.warnOnNoPropertiesFileExtension = true;
            attribs.useCompatibilityMode = true;
            attribs.locale = Locale.getDefault();
            return Factory.loadReferences(refs, attribs);
        }

        public static synchronized Properties loadReferences(List<PropertiesReference> refs, Attributes attribs) {
            LoadList list = new LoadList(attribs);
            for (PropertiesReference ref : refs) {
                list.addReference(ref);
            }
            list.load();
            return list.getProps();
        }
    }

    public static enum Mode {
        BasicToken,
        Compatibility,
        Line,
        Explicit;

    }
}

