/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocaleStringBuilder {
    Locale locale;
    String baseName;

    public LocaleStringBuilder(String baseName, Locale locale) {
        this.locale = locale;
        this.baseName = baseName.endsWith(".properties") ? baseName.substring(0, baseName.length() - 11) : baseName;
    }

    public List<String> getSearchStrings() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        if (!this.baseName.startsWith("/")) {
            b.append("/");
        }
        b.append(this.baseName).append(".properties");
        list.add(b.toString());
        if (this.hasLanguage()) {
            b = new StringBuilder();
            if (!this.baseName.startsWith("/")) {
                b.append("/");
            }
            b.append(this.baseName).append("_").append(this.locale.getLanguage()).append(".properties");
            list.add(b.toString());
        }
        if (this.hasLanguageCountry()) {
            b = new StringBuilder();
            if (!this.baseName.startsWith("/")) {
                b.append("/");
            }
            b.append(this.baseName).append("_").append(this.locale.getLanguage()).append("_").append(this.locale.getCountry()).append(".properties");
            list.add(b.toString());
        }
        if (this.hasLanguageCountryVariant()) {
            b = new StringBuilder();
            if (!this.baseName.startsWith("/")) {
                b.append("/");
            }
            b.append(this.baseName).append("_").append(this.locale.getLanguage()).append("_").append(this.locale.getCountry()).append("_").append(this.locale.getVariant()).append(".properties");
            list.add(b.toString());
        }
        return list;
    }

    private boolean hasLanguageCountryVariant() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        if (this.locale.getCountry().equals("")) {
            return false;
        }
        return !this.locale.getVariant().equals("");
    }

    private boolean hasLanguageCountry() {
        if (this.locale.getLanguage().equals("")) {
            return false;
        }
        return !this.locale.getCountry().equals("");
    }

    private boolean hasLanguage() {
        return !this.locale.getLanguage().equals("");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseName == null ? 0 : this.baseName.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocaleStringBuilder other = (LocaleStringBuilder)obj;
        if (this.baseName == null ? other.baseName != null : !this.baseName.equals(other.baseName)) {
            return false;
        }
        return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
    }
}

