/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.BasicValueModel;
import asia.redact.bracket.properties.BracketSaxHandler;
import asia.redact.bracket.util.AsciiToNativeFilterReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BracketCompatibilitySAXHandler
extends BracketSaxHandler {
    int count;
    StringBuffer keyBuf;
    Stack<String> keyStack = new Stack();
    List<String> comments = new ArrayList<String>();
    String separator;
    List<String> values = new ArrayList<String>();
    boolean commentOn;
    boolean separatorOn;
    boolean valueOn;

    @Override
    public void characters(char[] buffer, int start, int length) {
        String temp = new String(buffer, start, length);
        if (this.commentOn) {
            String decoded = this.helperDecodeUTFEscapes(temp);
            this.comments.add(decoded);
        } else if (this.separatorOn) {
            this.separator = temp;
        } else if (this.valueOn) {
            String decoded = this.helperDecodeUTFEscapes(temp);
            this.values.add(decoded);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.count == 0) {
            if (!qName.equals("nproperties")) throw new RuntimeException("Bracket properties serialized with xml must have a top level element called 'nproperties'");
            String namespace = attributes.getValue("xmlns");
            if (namespace == null || !namespace.equals("http://code.google.com/p/bracket-properties")) {
                throw new RuntimeException("Bad namespace, attribute xmlns must be set to 'http://code.google.com/p/bracket-properties'");
            }
        } else {
            if (qName.equals("c")) {
                this.commentOn = true;
                return;
            }
            if (qName.equals("s")) {
                this.separatorOn = true;
                return;
            }
            if (qName.equals("v")) {
                this.valueOn = true;
                return;
            }
            this.keyStack.push(qName.substring(1));
        }
        ++this.count;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("c")) {
            this.commentOn = false;
            return;
        }
        if (qName.equals("s")) {
            this.separatorOn = false;
            return;
        }
        if (qName.equals("v")) {
            this.valueOn = false;
            this.keyBuf = new StringBuffer();
            for (String part : this.keyStack) {
                if (this.keyBuf.length() > 0) {
                    this.keyBuf.append(".");
                }
                this.keyBuf.append(part);
            }
            BasicValueModel model = new BasicValueModel();
            model.setSeparator(this.separator.charAt(0));
            for (String value : this.values) {
                model.addValue(value);
            }
            for (String comment : this.comments) {
                model.addComment(comment);
            }
            this.props.getPropertyMap().put(this.keyBuf.toString(), model);
            this.keyBuf = null;
            this.values.clear();
            this.comments.clear();
            this.separator = null;
            this.keyStack.remove(qName);
            return;
        }
        this.keyStack.remove(qName.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String helperDecodeUTFEscapes(String encoded) {
        AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(new StringReader(encoded));
        StringBuilder builder = new StringBuilder();
        char[] array = new char[8120];
        int count = 0;
        try {
            while ((count = reader.read(array)) != -1) {
                builder.append(array, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return builder.toString();
    }
}

