/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.OutputFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class BasicOutputFormat
implements OutputFormat {
    protected static final String lineSeparator = System.getProperty("line.separator");
    protected static final SimpleDateFormat dateFormatISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    @Override
    public String formatContentType() {
        return "";
    }

    @Override
    public String formatHeader() {
        StringBuffer buf = new StringBuffer("#;; generated=");
        buf.append(dateFormatISO8601.format(new Date()));
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        return buf.toString();
    }

    @Override
    public String format(String key, char separator, List<String> values, List<String> comments) {
        if (key == null) {
            throw new RuntimeException("Key cannot be null in a format");
        }
        StringBuffer buf = new StringBuffer();
        if (comments != null && comments.size() > 0) {
            for (String c : comments) {
                buf.append(c);
                buf.append(lineSeparator);
            }
        }
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == ':' || ch == '=') {
                keyBuilder.append('\\');
            }
            keyBuilder.append(ch);
        }
        buf.append(keyBuilder.toString());
        buf.append(separator);
        if (values != null && values.size() > 0) {
            int count = values.size();
            int i = 0;
            for (String s : values) {
                buf.append(s);
                if (i < count - 1) {
                    buf.append('\\');
                }
                buf.append(lineSeparator);
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public String formatFooter() {
        StringBuffer buf = new StringBuffer(lineSeparator);
        buf.append("#;; eof");
        buf.append(lineSeparator);
        return buf.toString();
    }
}

