package asia.redact.bracket.properties;

import java.util.Comparator;
import java.util.TreeMap;

/**
 * <pre>
 * Adds sorted map capability, but with the overhead of a TreeMap.
 * 
 * </pre>
 * 
 * @author Dave
 *
 */
public class SortedPropertiesImpl extends PropertiesImpl {
	
	private static final long serialVersionUID = 1L;
	Comparator<String> comparator;

	public SortedPropertiesImpl() {
		super();
	}

	public SortedPropertiesImpl(Comparator<String> comparator) {
		super();
		this.comparator = comparator;
	}

	protected void initMap() {
		if(comparator == null) {
			map = new TreeMap<String,ValueModel>();
		}else{
			map = new TreeMap<String,ValueModel>(comparator);
		}
	}
}
