package asia.redact.bracket.properties;

import java.util.ArrayList;
import java.util.List;

/**
 * A ValueModel in which the internals cannot be changed once set.
 * 
 * @author Dave
 *
 */
public class ImmutableValueModel extends BasicValueModel {

	
	private static final long serialVersionUID = 1L;

	public ImmutableValueModel(List<String> comments, List<String> values) {
		super(comments, values);
	}

	public ImmutableValueModel(String... value) {
		super(value);
	}

	public char getSeparator() {
		return separator;
	}

	/**
	 * Return a copy only, do not expose our internals
	 */
	public List<String> getComments() {
		
		List<String> copy = new ArrayList<String>();
		copy.addAll(comments);
		return copy;
	}

	public List<String> getValues() {
		// TODO Auto-generated method stub
		List<String> copy = new ArrayList<String>();
		copy.addAll(values);
		return copy;
	}
	
	public void setSeparator(char separator) {
		throw new UnsupportedOperationException("Cannot set separator, immutable");
	}
	
	public void addValue(String value){
		throw new UnsupportedOperationException("Cannot add value, immutable");
	}
	
	public void addComment(String comment){
		throw new UnsupportedOperationException("Cannot add comment, immutable");
	}
	
	public void clearComments() {
		throw new UnsupportedOperationException("Cannot clear comments, immutable");
	}

}
