/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.mgmt;

import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.mgmt.ServerLocale;
import asia.redact.bracket.properties.mgmt.ServerLocalizedFileFinder;
import asia.redact.bracket.properties.mgmt.ServerLocalizedFileInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLocalizedProperties
extends PropertiesImpl {
    ServerLocale locale;
    String baseName;
    List<File> locationsToSearch;

    public ServerLocalizedProperties(ServerLocale locale, String baseName) {
        this.locale = locale;
        if (locale == null) {
            throw new RuntimeException("A locale must be provided");
        }
        if (baseName == null || baseName.length() == 0) {
            throw new RuntimeException("A baseName must be non-null and non-empty");
        }
    }

    public void loadFrom(List<File> locationsToSearch) {
        ServerLocalizedFileFinder finder = new ServerLocalizedFileFinder(locationsToSearch, this.baseName);
        List<File> files = finder.findFiles();
        for (File file : files) {
            ServerLocalizedFileInfo info = ServerLocale.fromFileName(file.getName());
            if (!this.locale.includes(info.locale)) continue;
            try {
                FileReader in = new FileReader(file);
                PropertiesLexer lexer = new PropertiesLexer(in);
                lexer.lex();
                List<PropertiesToken> list = lexer.getList();
                new PropertiesParser(list, this).parse();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

