/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.mgmt;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLocalizedFileFinder {
    List<File> parentFolders = new ArrayList<File>();
    String baseName;

    private ServerLocalizedFileFinder() {
    }

    public ServerLocalizedFileFinder(File parentFolder, String baseName) {
        this();
        this.parentFolders.add(parentFolder);
        this.baseName = baseName.endsWith(".properties") ? baseName.substring(0, baseName.length() - 11) : baseName;
    }

    public ServerLocalizedFileFinder(List<File> parentFolders, String baseName) {
        this();
        parentFolders.addAll(parentFolders);
        this.baseName = baseName.endsWith(".properties") ? baseName.substring(0, baseName.length() - 11) : baseName;
    }

    public List<File> findFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (File folder : this.parentFolders) {
            File[] files;
            for (File f : files = folder.listFiles(new MyFileFilter(this.baseName))) {
                list.add(f);
            }
        }
        if (list.size() > 1) {
            Collections.sort(list, new MyComparator());
        }
        return list;
    }

    class MyFileFilter
    implements FileFilter {
        String baseName;

        public MyFileFilter(String baseName) {
            this.baseName = baseName;
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().startsWith(this.baseName) && pathname.getName().endsWith(".properties");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyComparator
    implements Comparator<File> {
        MyComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            String name0 = o1.getName();
            String name1 = o2.getName();
            int c0 = this.countUnderscores(name0);
            int c1 = this.countUnderscores(name1);
            int resultUnderscores = 0;
            if (c0 > c1) {
                resultUnderscores = 1;
            }
            if (c0 < c1) {
                resultUnderscores = -1;
            }
            return resultUnderscores;
        }

        private int countUnderscores(String s) {
            int count = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '_') continue;
                ++count;
            }
            return count;
        }
    }
}

