/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.example;

import asia.redact.bracket.properties.OutputFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentMultilineFormat
implements OutputFormat {
    static final String lineSeparator = System.getProperty("line.separator");
    int tabCount;
    char tabChar;

    public IndentMultilineFormat(int tabCount, char tabChar) {
        this.tabCount = tabCount;
        this.tabChar = tabChar;
    }

    @Override
    public String format(String key, char separator, List<String> values, List<String> comments) {
        if (key == null) {
            throw new RuntimeException("Key cannot be null in a format");
        }
        StringBuffer buf = new StringBuffer();
        for (String c : comments) {
            buf.append(c);
            buf.append(lineSeparator);
        }
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == ':' || ch == '=') {
                keyBuilder.append('\\');
            }
            keyBuilder.append(ch);
        }
        buf.append(keyBuilder.toString());
        buf.append(separator);
        int count = values.size();
        int i = 0;
        for (String s : values) {
            if (i != 0) {
                for (int tc = 0; tc < this.tabCount; ++tc) {
                    buf.append(this.tabChar);
                }
                buf.append(" ");
                buf.append(s);
            } else {
                buf.append(s);
            }
            if (i < count - 1) {
                buf.append('\\');
            }
            buf.append(lineSeparator);
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String formatHeader() {
        return "";
    }

    @Override
    public String formatFooter() {
        return "";
    }
}

