/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.alt;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesParser2;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.properties.line.Line;
import asia.redact.bracket.properties.line.LineScanner;

public class DotPropertiesParser
extends PropertiesParser2 {
    String fullKey;

    public DotPropertiesParser(LineScanner scanner) {
        super(scanner);
    }

    public DotPropertiesParser(LineScanner scanner, Properties props) {
        super(scanner, props);
    }

    public void parse() {
        Line line = null;
        String key = null;
        ValueModel model = new ValueModel();
        boolean hasContinuation = false;
        while ((line = this.scanner.line()) != null) {
            String[] parts;
            if (hasContinuation) {
                model.addValue(line.logicalLineContents());
                if (line.hasContinuation()) continue;
                hasContinuation = false;
            }
            if (line.isEmptyLine() || line.isPrivateComment()) continue;
            if (line.isCommentLine()) {
                if (key != null) {
                    this.props.getPropertyMap().put(key, model);
                    key = null;
                    model = new ValueModel();
                }
                model.addComment(line.commentContents());
                continue;
            }
            if (!line.isNaturalLine()) continue;
            if (key != null) {
                this.props.getPropertyMap().put(key, model);
                key = null;
                model = new ValueModel();
            }
            if (!(key = (parts = line.naturalLineContents())[0]).startsWith(".")) {
                this.fullKey = key;
            } else {
                key = this.fullKey + key;
            }
            model.setSeparator(parts[1].charAt(0));
            hasContinuation = line.hasContinuation();
            model.addValue(parts[2]);
        }
        if (key != null) {
            this.props.getPropertyMap().put(key, model);
        }
    }
}

