/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueModel {
    static final String lineSeparator = System.getProperty("line.separator");
    protected final List<String> comments;
    protected final List<String> values;
    protected char separator = (char)61;

    public ValueModel() {
        this.comments = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    public ValueModel(String ... value) {
        this();
        for (String v : value) {
            this.values.add(v);
        }
    }

    ValueModel(List<String> comments, List<String> values) {
        this.comments = comments;
        this.values = values;
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : ((Object)this.comments).hashCode());
        result = 31 * result + this.separator;
        result = 31 * result + (this.values == null ? 0 : ((Object)this.values).hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueModel other = (ValueModel)obj;
        if (this.comments == null ? other.comments != null : !((Object)this.comments).equals(other.comments)) {
            return false;
        }
        if (this.separator != other.separator) {
            return false;
        }
        return !(this.values == null ? other.values != null : !((Object)this.values).equals(other.values));
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void clearComments() {
        this.comments.clear();
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (String value : this.values) {
            b.append(value);
        }
        return b.toString();
    }

    public String toString() {
        return this.getValue();
    }

    public String toXML(int spaces) {
        StringBuilder sp = new StringBuilder();
        for (int i = 0; i <= spaces; ++i) {
            sp.append(" ");
        }
        StringBuilder builder = new StringBuilder();
        for (String comment : this.comments) {
            builder.append(sp.toString());
            builder.append("<comment><![CDATA[").append(comment).append("]]></comment>").append(lineSeparator);
        }
        builder.append(sp.toString());
        builder.append("<separator>").append(this.separator).append("</separator>").append(lineSeparator);
        for (String value : this.values) {
            builder.append(sp.toString());
            if (value != null && !value.equals("")) {
                builder.append("<value><![CDATA[").append(value).append("]]></value>").append(lineSeparator);
                continue;
            }
            builder.append("<value/>").append(lineSeparator);
        }
        return builder.toString();
    }
}

